% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.edit.recode.pop.r
\name{gl.edit.recode.pop}
\alias{gl.edit.recode.pop}
\title{Creates or edits a population re-assignment table}
\usage{
gl.edit.recode.pop(
  x,
  pop.recode = NULL,
  out.recode.file = NULL,
  outpath = tempdir(),
  recalc = FALSE,
  mono.rm = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object for which populations are to be
reassigned [required].}

\item{pop.recode}{Path to recode file [default NULL].}

\item{out.recode.file}{Name of the file to output the new individual labels
[default NULL].}

\item{outpath}{Path where to save the output file [default tempdir(), mandated by CRAN].}

\item{recalc}{Recalculate the locus metadata statistics if any individuals are deleted
[default TRUE].}

\item{mono.rm}{Remove monomorphic loci [default TRUE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
An object of class ('genlight') with the revised population assignments
}
\description{
A script to edit population assignments in a genlight object, or to
create a reassignment table taking the population assignments
from a genlight object, or to edit existing population assignments in
a pop.recode.table.
}
\details{
Genlight objects assign specimens to populations based on information in the
ind.metadata file provided when the genlight object is first generated.
Often one wishes to subset the data by deleting populations or to amalgamate
populations. This can be done with a pop.recode table with two columns. The
first column is the population assignment in the genlight object, the second
column provides the new assignment.

This script will input an existing reassignment table for editing and
optionally save it as a new table, or if the name of an input table is not
supplied, will generate a table using the population assignments in the
parent genlight object.

The script, having deleted populations, optionally identifies resultant
monomorphic loci or loci with all values missing and deletes them (using
gl.filter.monomorphs.r). The script also optionally recalculates statistics
 made redundant by the deletion of individuals from the dataset.

Use outpath=getwd() or outpath='.' when calling this function to direct
output files to your working directory.

The script returns a genlight object with the new population assignments and
the recalculated locus metadata.
}
\examples{
\dontrun{
gl <- gl.edit.recode.pop(testset.gl)
gs <- gl.edit.recode.pop(testset.gs)
}
}
\seealso{
\code{\link{gl.recode.pop}}, \code{\link{gl.drop.pop}},
\code{\link{gl.keep.pop}}, \code{\link{gl.merge.pop}},
\code{\link{gl.reassign.pop}}
}
\author{
Custodian: Arthur Georges --Post to
\url{https://groups.google.com/d/forum/dartr}
}
