% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2vcf.r
\name{gl2vcf}
\alias{gl2vcf}
\title{Converts a genlight object into vcf format}
\usage{
gl2vcf(
  x,
  plink.bin.path = getwd(),
  outfile = "gl_vcf",
  outpath = NULL,
  snp.pos = "0",
  snp.chr = "0",
  chr.format = "character",
  pos.cM = "0",
  ID.dad = "0",
  ID.mum = "0",
  sex.code = "unknown",
  phen.value = "0",
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{plink.bin.path}{Path of PLINK binary file [default getwd())].}

\item{outfile}{File name of the output file [default 'gl_vcf'].}

\item{outpath}{Path where to save the output file [default global working 
directory or if not specified, tempdir()].}

\item{snp.pos}{Field name from the slot loc.metrics where the SNP position is
stored [default '0'].}

\item{snp.chr}{Field name from the slot loc.metrics where the chromosome of
each is stored [default '0'].}

\item{chr.format}{Whether chromosome information is stored as 'numeric' or as
'character', see details [default 'character'].}

\item{pos.cM}{A vector, with as many elements as there are loci, containing
the SNP position in morgans or centimorgans [default '0'].}

\item{ID.dad}{A vector, with as many elements as there are individuals,
containing the ID of the father, '0' if father isn't in dataset [default '0'].}

\item{ID.mum}{A vector, with as many elements as there are individuals,
containing the ID of the mother, '0' if mother isn't in dataset [default '0'].}

\item{sex.code}{A vector, with as many elements as there are individuals,
containing the sex code ('male', 'female', 'unknown') [default  'unknown'].}

\item{phen.value}{A vector, with as many elements as there are individuals,
containing the phenotype value. '1' = control, '2' = case, '0' = unknown
[default '0'].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
returns no value (i.e. NULL)
}
\description{
This function exports a genlight object into VCF format and save it into a
file.
}
\details{
This function requires to download the binary file of PLINK 1.9 and provide
its path (plink.bin.path).
The binary file can be downloaded from:
\url{https://www.cog-genomics.org/plink/}
The chromosome information for unmapped SNPS is coded as 0.
Family ID is taken from  x$pop
Within-family ID (cannot be '0') is taken from indNames(x)
Variant identifier is taken from locNames(x)
}
\examples{
\dontrun{
#this example needs plink installed to work
require("dartR.data")
gl2vcf(platypus.gl,snp.pos='ChromPos_Platypus_Chrom_NCBIv1',
 snp.chr = 'Chrom_Platypus_Chrom_NCBIv1')
}

}
\references{
Danecek, P., Auton, A., Abecasis, G., Albers, C. A., Banks, E., DePristo, M.
 A., ... & 1000 Genomes Project Analysis Group. (2011). The variant call
 format and VCFtools. Bioinformatics, 27(15), 2156-2158.
}
\seealso{
Other linker: 
\code{\link{gl2bayesAss}()},
\code{\link{gl2bayescan}()},
\code{\link{gl2bpp}()},
\code{\link{gl2demerelate}()},
\code{\link{gl2eigenstrat}()},
\code{\link{gl2faststructure}()},
\code{\link{gl2gds}()},
\code{\link{gl2genalex}()},
\code{\link{gl2genepop}()},
\code{\link{gl2geno}()},
\code{\link{gl2gi}()},
\code{\link{gl2hiphop}()},
\code{\link{gl2phylip}()},
\code{\link{gl2plink}()},
\code{\link{gl2related}()},
\code{\link{gl2sa}()},
\code{\link{gl2structure}()},
\code{\link{gl2treemix}()}
}
\author{
Custodian: Luis Mijangos (Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{linker}
