% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_solve.R
\name{calc_log_like}
\alias{calc_log_like}
\alias{log_like_heart}
\title{Calculate the Log-Likelihood}
\usage{
calc_log_like(pdfs, t_vec, obs_data, conds)

log_like_heart(pdf_u, pdf_l, t_vec, rts_u, rts_l)
}
\arguments{
\item{pdfs}{a list of pdfs (see details)}

\item{t_vec}{time space}

\item{obs_data}{a list of obs_data}

\item{conds}{all conditions of a model}

\item{pdf_u, pdf_l}{numeric vectors of the pdfs (unpacked)}

\item{rts_u, rts_l}{numeric vectors of the observed RTs (unpacked)}
}
\value{
a single value of the log-likelihood
}
\description{
Wrapper function around \code{log_like_heart}
}
\details{
\subsection{calc_log_like}{

Iterates over all conditions, and passes forward the (unpacked) arguments
to \code{log_like_heart}, adding each log-likelihood of a condition.

\code{pdfs} must be a list with entries named as the conditions, and then
each condition being a list of the two PDFs (named pdf_u and pdf_l)

\code{obs_data} must be a list with entries "rts_u" and "rts_l", and then
each rts_* entry being a named list with the RT values for each condition
}

\subsection{log_like_heart}{

Gets the density values for RTs in rts_u/rts_l via \code{\link[stats:approxfun]{stats::approx()}},
takes the log of that, and then sums across both.
Wraps up the calculation in a tryCatch statement, throwing warnings when
log_like_values can not be calculated
}
}
\keyword{internal}
