% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dGAselID.R
\name{dGAselID}
\alias{dGAselID}
\title{dGAselID}
\usage{
dGAselID(x, response, method = knnI(k = 3, l = 2), trainTest = "LOG",
  startGenes, populationSize, iterations, noChr = 22, elitism = NA,
  ID = "ID1", pMutationChance = NA, randomAssortment = TRUE,
  embryonicSelection = NA, EveryGeneInInitialPopulation = TRUE,
  nnetSize = NA, nnetDecay = NA, rdaAlpha = NA, rdaDelta = NA, ...)
}
\arguments{
\item{x}{Dataset in ExpressionSet format.}

\item{response}{Response variable}

\item{method}{Supervised classifier for fitness evaluation. Most of the supervised classifiers in MLInterfaces are acceptable. The default is knnI(k=3, l=2).}

\item{trainTest}{Cross-validation method. The default is "LOG".}

\item{startGenes}{Genes in the genotypes at initialization.}

\item{populationSize}{Number of genotypes in initial population.}

\item{iterations}{Number of iterations.}

\item{noChr}{Number of chromosomes. The default value is 22.}

\item{elitism}{Elite population in percentages.}

\item{ID}{Incomplete Dominance. The default value is "ID1". Use "ID2" for elitism applied to individuals.}

\item{pMutationChance}{Chance for a point mutation to occur.}

\item{randomAssortment}{Random Assortment of Chromosomes for recombinations. The default value is TRUE.}

\item{embryonicSelection}{Remove chromosomes with fitness < specified value. The default value is NA.}

\item{EveryGeneInInitialPopulation}{Request for every gene to be present in the initial population. The default value is TRUE.}

\item{nnetSize}{for nnetI. The default value is NA.}

\item{nnetDecay}{for nnetI. The default value is NA.}

\item{rdaAlpha}{for rdaI. The default value is NA.}

\item{rdaDelta}{for rdaI. The default value is NA.}

\item{...}{Additional arguments.}
}
\description{
Initializes and starts the search with the genetic algorithm.
}
\examples{
\dontrun{
 library(genefilter)
 library(ALL)
 data(ALL)
 bALL = ALL[, substr(ALL$BT,1,1) == "B"]
 smallALL = bALL[, bALL$mol.biol \%in\% c("BCR/ABL", "NEG")]
 smallALL$mol.biol = factor(smallALL$mol.biol)
 smallALL$BT = factor(smallALL$BT)
 f1 <- pOverA(0.25, 9)
 f2 <- function(x) (IQR(x) > 0.75)
 f3 <- ttest(smallALL$mol.biol, p=0.1)
 ff <- filterfun(f1, f2, f3)
 selectedsmallALL <- genefilter(exprs(smallALL), ff)
 sum(selectedsmallALL)

 set.seed(1357)
 res1<-dGAselID(smallALL, "mol.biol", method=knn.cvI(k=3, l=2), trainTest=1:79,
   startGenes=5, populationSize=50, iterations=4, noChr=5, mutationChance=0.05,
   elitism=10, ID="ID1")
 }
}

