% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getResponse.R
\name{GetResponse}
\alias{GetResponse}
\alias{GetResponse.default}
\alias{GetResponse.merMod}
\alias{GetResponse.lme}
\alias{GetResponse.glmmTMB}
\title{Extract Response Variable}
\usage{
GetResponse(model, ...)

\method{GetResponse}{default}(model, ...)

\method{GetResponse}{merMod}(model, ...)

\method{GetResponse}{lme}(model, ...)

\method{GetResponse}{glmmTMB}(model, ...)
}
\arguments{
\item{model}{a fitted model}

\item{...}{additional parameters for specific methods}
}
\value{
a numeric vector containing the values of the response variable.
}
\description{
Generic function to extract the response variable from a fitted model.
}
\details{
The supplied \code{default} method returns the \code{model$y} component
of the model object, or, if \code{model} is an S4 object, the result
returned by the \code{\link[insight]{get_response}()} function in
the \pkg{insight} package. If this result is \code{NULL}, the result of
\code{model.response(model.frame(model))} is returned, checking in any case whether
the result is a numeric vector.

There is also an \code{"lme"} method, and \code{"merMod"}
and \code{"glmmTMB"} methods that convert factor
responses to numeric 0/1 responses, as would be appropriate
for a generalized linear mixed model with a binary response.
}
\section{Methods (by class)}{
\itemize{
\item \code{GetResponse(default)}: \code{default} method

\item \code{GetResponse(merMod)}: \code{merMod} method

\item \code{GetResponse(lme)}: \code{merMod} method

\item \code{GetResponse(glmmTMB)}: \code{glmmTMB} method

}}
\examples{
    fit <- lm(mpg ~ gear, mtcars)
    GetResponse(fit)
}
