% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_median.R
\name{oc_median}
\alias{oc_median}
\title{Use the sample median as cutpoint}
\usage{
oc_median(data, x, ...)
}
\arguments{
\item{data}{A data frame or tibble in which the columns that are given in x
and class can be found.}

\item{x}{(character) The variable name to be used for classification,
e.g. predictions or test values.}

\item{...}{To capture further arguments that are always passed to the method
function by cutpointr. The cutpointr function passes data, x, class,
metric_func, direction, pos_class and neg_class to the method function.}
}
\description{
The sample median is calculated and returned as the optimal cutpoint.
}
\examples{
data(suicide)
oc_median(suicide, "dsi")
cutpointr(suicide, dsi, suicide, method = oc_median)
}
\seealso{
Other method functions: \code{\link{maximize_boot_metric}},
  \code{\link{maximize_gam_metric}},
  \code{\link{maximize_loess_metric}},
  \code{\link{maximize_metric}},
  \code{\link{maximize_spline_metric}},
  \code{\link{oc_manual}}, \code{\link{oc_mean}},
  \code{\link{oc_youden_kernel}},
  \code{\link{oc_youden_normal}}
}
