% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dbFindFields}
\alias{dbFindFields}
\title{Find names of fields in the database collection}
\usage{
dbFindFields(namepart = "", con, verbose = FALSE)
}
\arguments{
\item{namepart}{A plain string (not a regular expression) to
be searched for among all field names (keys) in the database.}

\item{con}{A \link[nodbi]{src} connection object, as obtained with
nodbi::\link[nodbi]{src_mongo}() or nodbi::\link[nodbi]{src_sqlite}()}

\item{verbose}{If \code{TRUE}, prints additional information (default \code{FALSE}).}
}
\value{
Vector of field(s) found
}
\description{
Given part of the name of a field of interest to the user, this
function returns the full field names as found in the database.
}
\details{
For fields in EUCTR (protocol- and results-related information),
see also the register's documentation at
\url{https://eudract.ema.europa.eu/}.

For fields in CTGOV (protocol-related information), see also
the register's definitions at
\url{https://prsinfo.clinicaltrials.gov/definitions.html}.

Note: Generating a list of fields with this function may take
some time, and may involve running a mapreduce function is
run on the server. If the user is not not authorised to run
such a function on the (local or remote) server,
random documents are sampled to generate a list of fields.
}
\examples{

\dontrun{
 dbFindFields("date")
}

}
