% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflections.R
\name{deplete_systematic_absences}
\alias{deplete_systematic_absences}
\title{Deplete systematic absences}
\usage{
deplete_systematic_absences(hkl, SG)
}
\arguments{
\item{hkl}{A data frame with first three columns H, K, L
corresponding to the three Miller indices. This is
normally the 'record' data frame in an object of
class "merged_reflections".}

\item{SG}{A character. The extended Hermann-Mauguin symbol
of the crystallographic space group.}
}
\value{
hkl The same data frame acquired from input, depleted
            of all systematic absences.
}
\description{
Remove systematically-absent reflections from a data frame
in which Miller indices are in the first three columns.
The systematically-absent reflections are determined by the
specific space group.
}
\details{
Crystallography symmetry forces constraints on data from
x-ray diffraction. One of these constraints consists in the
full cancellation of reflections with certain Miller indices.
It is said that the reflection with that specific Miller index
is systematically absent. For example, in data corresponding
to a crystal with space group C 2, general reflections like
(h,k,l) must obey h+k=2n (even number). Thus, the Miller
indices (2,3,1) are a systematic absence because 2+3=5 (odd).
}
\examples{
# C 2 monoclinic space group
SG <-"C 1 2 1"

# Create an arbitrary cell compatible with C 2
uc <- unit_cell(10,15,10,90,110,90)

# Crete the related reciprocal cell
ruc <- create_rec_unit_cell(uc)

# Create a full data frame of Miller indices
hkl <- expand.grid(H=-4:4,K=-4:4,L=-4:4)

# Get rid of systematic absences
new_hkl <- deplete_systematic_absences(hkl,SG)

# Compare first 10 items of original and depleted arrays
hkl[1:10,]
new_hkl[1:10,]

}
