% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_schedule.R
\name{crew_class_schedule}
\alias{crew_class_schedule}
\title{Schedule class}
\description{
\code{R6} class to contain and manage task objects.
}
\details{
Not a user-side class. There are no examples. Please see
\code{\link[=crew_controller_local]{crew_controller_local()}} for details.
}
\seealso{
Other class: 
\code{\link{crew_class_client}},
\code{\link{crew_class_controller_group}},
\code{\link{crew_class_controller}},
\code{\link{crew_class_launcher}},
\code{\link{crew_class_tls}}
}
\concept{class}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{seconds_interval}}{See \code{\link[=crew_schedule]{crew_schedule()}}.}

\item{\code{pushed}}{Hash table of pushed tasks.}

\item{\code{collected}}{Linked list of resolved tasks with results available.}

\item{\code{pushes}}{Number of times a task has been pushed.}

\item{\code{head}}{ID of the task at the head of the \code{collected} linked list.}

\item{\code{tail}}{ID of the task at the tail of the \code{collected} linked list.}

\item{\code{until}}{Numeric of length 1, time point when
throttled task collection unlocks.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_schedule-new}{\code{crew_class_schedule$new()}}
\item \href{#method-crew_class_schedule-validate}{\code{crew_class_schedule$validate()}}
\item \href{#method-crew_class_schedule-start}{\code{crew_class_schedule$start()}}
\item \href{#method-crew_class_schedule-summary}{\code{crew_class_schedule$summary()}}
\item \href{#method-crew_class_schedule-push}{\code{crew_class_schedule$push()}}
\item \href{#method-crew_class_schedule-throttle}{\code{crew_class_schedule$throttle()}}
\item \href{#method-crew_class_schedule-collect}{\code{crew_class_schedule$collect()}}
\item \href{#method-crew_class_schedule-list}{\code{crew_class_schedule$list()}}
\item \href{#method-crew_class_schedule-pop}{\code{crew_class_schedule$pop()}}
\item \href{#method-crew_class_schedule-empty}{\code{crew_class_schedule$empty()}}
\item \href{#method-crew_class_schedule-nonempty}{\code{crew_class_schedule$nonempty()}}
\item \href{#method-crew_class_schedule-collected_all}{\code{crew_class_schedule$collected_all()}}
\item \href{#method-crew_class_schedule-collected_one}{\code{crew_class_schedule$collected_one()}}
\item \href{#method-crew_class_schedule-collected_mode}{\code{crew_class_schedule$collected_mode()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-new}{}}}
\subsection{Method \code{new()}}{
Schedule constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$new(seconds_interval = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{seconds_interval}}{See \code{\link[=crew_schedule]{crew_schedule()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} schedule object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the schedule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-start}{}}}
\subsection{Method \code{start()}}{
Start the schedule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$start()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Sets the \code{pushed} and \code{collected} hash tables to new
empty environments.
}

\subsection{Returns}{
NULL (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-summary"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-summary}{}}}
\subsection{Method \code{summary()}}{
Summarize the schedule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} if not started. Otherwise, a \code{tibble} with
the following columns:
\itemize{
\item \code{pushed}: number tasks that were pushed but not collected yet.
These tasks may or may not have completed.
\item \code{collected}: number of tasks that completed and were collected
but not yet retrieved with \code{pop()}.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-push"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-push}{}}}
\subsection{Method \code{push()}}{
Push a task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$push(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{The \code{mirai} task object to push.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Add a task to the \code{pushed} hash table
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-throttle"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-throttle}{}}}
\subsection{Method \code{throttle()}}{
Throttle repeated calls.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$throttle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} to throttle, \code{FALSE} to continue.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-collect"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-collect}{}}}
\subsection{Method \code{collect()}}{
Collect resolved tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$collect(throttle = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{whether to defer task collection
until the next task collection request at least
\code{seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Scan the tasks in \code{pushed} and move the resolved ones to the
head of the \code{collected} linked list.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-list"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-list}{}}}
\subsection{Method \code{list()}}{
List collected tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$list()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Exists to support a \code{purrr}-like extension to \code{crew} for
functional programming. For developers only. Not supported
for controller groups.
}

\subsection{Returns}{
A list of monad objects from individual tasks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-pop"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-pop}{}}}
\subsection{Method \code{pop()}}{
Pop a task from the \code{collected} linked list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$pop()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A task object if available, \code{NULL} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-empty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-empty}{}}}
\subsection{Method \code{empty()}}{
Check if the schedule is empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the \code{pushed} and \code{collected} hash tables are both
empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-nonempty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-nonempty}{}}}
\subsection{Method \code{nonempty()}}{
Check if the schedule is nonempty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$nonempty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if either \code{pushed} or \code{collected} is nonempty,
\code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-collected_all"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-collected_all}{}}}
\subsection{Method \code{collected_all()}}{
Check if all previously pushed tasks are now collected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$collected_all()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if all previously pushed tasks are now collected,
\code{FALSE} otherwise. Could be \code{FALSE} if there are unresolved tasks
or there are no tasks at all.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-collected_one"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-collected_one}{}}}
\subsection{Method \code{collected_one()}}{
Check if there is at least one collected task or
there are no pushed tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$collected_one()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if there is at least one collected task or
there are no pushed tasks, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_schedule-collected_mode"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_schedule-collected_mode}{}}}
\subsection{Method \code{collected_mode()}}{
Either \code{collected_all()} or \code{collected_one()}, depending
on the \code{mode} argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_schedule$collected_mode(mode = "all")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{\code{"all"} to call \code{collected_all()} or \code{"one"} to call
\code{collected_one()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} or \code{FALSE}, depending on \code{mode} and the state of the
schedule.
}
}
}
