% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/string_operations.r
\name{col_strsplit}
\alias{col_strsplit}
\title{Split an ANSI colored string}
\usage{
col_strsplit(x, split, ...)
}
\arguments{
\item{x}{Character vector, potentially ANSI styled, or a vector to
coarced to character.}

\item{split}{Character vector (or object which can be coerced to such)
containing regular expression(s) (unless \code{fixed = TRUE}) to use for
splitting.  If empty matches occur, in particular if \code{split} has
length 0, \code{x} is split into single characters.  If \code{split} has
length greater than 1, it is re-cycled along \code{x}.}

\item{...}{Extra arguments are passed to \code{base::strsplit}.}
}
\value{
A list of the same length as \code{x}, the \eqn{i}-th element of
  which contains the vector of splits of \code{x[i]}. ANSI styles are
  retained.
}
\description{
This is the color-aware counterpart of \code{base::strsplit}.
It works exactly like the original, but keeps the colors in the
substrings.
}
\examples{
str <- red("I am red---") \%+\%
  green("and I am green-") \%+\%
  underline("I underlined")

cat(str, "\\n")

# split at dashes, keep color
cat(col_strsplit(str, "[-]+")[[1]], sep = "\\n")
strsplit(strip_style(str), "[-]+")

# split to characters, keep color
cat(col_strsplit(str, "")[[1]], "\\n", sep = " ")
strsplit(strip_style(str), "")
}
\seealso{
Other ANSI string operations: \code{\link{col_nchar}};
  \code{\link{col_substring}}; \code{\link{col_substr}}
}

