% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{World}
\alias{World}
\title{Data on countries from the Happy Planet Index project.}
\format{
A data frame with 130 observations on the following 14 variables:
\describe{
\item{\code{Country}}{Name of country}
\item{\code{Region}}{One of 5 UN defined regions: Africa, Americas, Asia, Europe, Oceania}
\item{\code{Code}}{Three-letter country codes defined by the International Organization for Standardization (\href{https://www.iso.org/iso-3166-country-codes.html}{ISO}) to represent countries in a way that avoids errors since a country’s name changes depending on the language being used.}
\item{\code{LifeExpectancy}}{Average life expectancy (in years)}
\item{\code{GirlsH1900}}{The average of 18-year-old girls heights in 1900 (in cm)}
\item{\code{GirlsH1980}}{The average of 18-year-old girls heights in 1980 (in cm)}
\item{\code{Happiness}}{Score on a 0-10 scale for average level of happiness (10 being happiest)}
\item{\code{GDPperCapita}}{Gross Domestic Product (per capita)}
\item{\code{FertRate}}{The average number of children that will be born to a woman over her lifetime}
\item{\code{PeopleVacc}}{Total number of people vaccinated in the country}
\item{\code{PeopleVacc_per100}}{Total number of people vaccinated in the country (in percent)}
\item{\code{Population2010}}{Population (in millions) in 2010}
\item{\code{Population2020}}{Population (in millions) in 2020}
\item{\code{WineServ}}{Average wine consumption per capita for those age 15 and over per week (collected by WHO)}
}
}
\usage{
World
}
\description{
These data have been updated with some historical height data (from \href{https://ourworldindata.org/human-height}{Our World in Data}), drinking data (collected by the World Health
Organization featured in
\href{https://fivethirtyeight.com/features/dear-mona-followup-where-do-people-drink-the-most-beer-wine-and-spirits/}{fivethirtyeight}),
population and land characteristics, and vaccination data (from March 2023).
}
\keyword{datasets}
