% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svywatts.R
\name{svywatts}
\alias{svywatts}
\alias{svywatts.survey.design}
\alias{svywatts.svyrep.design}
\alias{svywatts.DBIsvydesign}
\title{Watts measure of poverty}
\usage{
svywatts(formula, design, ...)

\method{svywatts}{survey.design}(
  formula,
  design,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 0.6,
  quantiles = 0.5,
  thresh = FALSE,
  na.rm = FALSE,
  deff = FALSE,
  linearized = FALSE,
  influence = FALSE,
  ...
)

\method{svywatts}{svyrep.design}(
  formula,
  design,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 0.6,
  quantiles = 0.5,
  thresh = FALSE,
  na.rm = FALSE,
  deff = FALSE,
  linearized = FALSE,
  return.replicates = FALSE,
  ...
)

\method{svywatts}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{passed to \code{svyarpr} and \code{svyarpt}}

\item{type_thresh}{type of poverty threshold. If "abs" the threshold is fixed and given the value
of abs_thresh; if "relq" it is given by percent times the quantile; if "relm" it is percent times the mean.}

\item{abs_thresh}{poverty threshold value if type_thresh is "abs"}

\item{percent}{the multiple of the the quantile or mean used in the poverty threshold definition}

\item{quantiles}{the quantile used used in the poverty threshold definition}

\item{thresh}{return the poverty threshold value}

\item{na.rm}{Should cases with missing values be dropped?}

\item{deff}{Return the design effect (see \code{survey::svymean})}

\item{linearized}{Should a matrix of linearized variables be returned}

\item{influence}{Should a matrix of (weighted) influence functions be returned? (for compatibility with \code{\link[survey]{svyby}}). Not implemented yet for linearized designs.}

\item{return.replicates}{Return the replicate estimates?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the Watts measure for the cases: \code{alpha=0} headcount ratio and \code{alpha=1} poverty gap index.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.

For the \code{svywatts} and \code{svywattsdec} functions, zeroes and negative numbers in the analysis domain cause an error because of the logarithm function in the definition of this poverty measure.  However, zeroes and negative values in the full survey design that are outside of the domain of analysis are valid to calculate the poverty threshold because zeroes and negatives are not a problem for computing quantiles (used when \code{type_thresh = "relq"}) or means (used when \code{type_thresh = "relm"}) . Missing values are treated differently.  \code{NA} values anywhere in the full survey design (not only the subset, or the domain of analysis) will cause these quantiles and means to return \code{NA} results.  To ignore \code{NA} values throughout, set \code{na.rm = TRUE}.
}
\examples{
library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design

des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep( des_eusilc_rep )

# filter positive incomes
des_eusilc <- subset( des_eusilc , eqincome > 0 )
des_eusilc_rep <- subset( des_eusilc_rep , eqincome > 0 )

# poverty threshold fixed
svywatts(~eqincome, des_eusilc ,  abs_thresh=10000)
# poverty threshold equal to arpt
svywatts(~eqincome, des_eusilc , type_thresh= "relq", thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svywatts(~eqincome, des_eusilc , type_thresh= "relm" , thresh = TRUE)
# using svrep.design:
# poverty threshold fixed
svywatts(~eqincome, des_eusilc_rep  ,  abs_thresh=10000)
# poverty threshold equal to arpt
svywatts(~eqincome, des_eusilc_rep  , type_thresh= "relq", thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svywatts(~eqincome, des_eusilc_rep  , type_thresh= "relm" , thresh = TRUE)

\dontrun{

# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )

# filter positive incomes
dbd_eusilc <- subset( dbd_eusilc , eqincome > 0 )

# poverty threshold fixed
svywatts(~eqincome, dbd_eusilc ,  abs_thresh=10000)
# poverty threshold equal to arpt
svywatts(~eqincome, dbd_eusilc , type_thresh= "relq", thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svywatts(~eqincome, dbd_eusilc , type_thresh= "relm" , thresh = TRUE)

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Harold W. Watts (1968). An economic definition of poverty.
\emph{Institute For Research on Poverty Discussion Papers}, n.5.
University of Wisconsin. URL \url{https://www.irp.wisc.edu/publications/dps/pdfs/dp568.pdf}.

Buhong Zheng (2001). Statistical inference for poverty measures with relative poverty lines.
\emph{Journal of Econometrics}, Vol. 101, pp. 337-356.

Vijay Verma and Gianni Betti (2011). Taylor linearization sampling errors and design effects for poverty measures
and other complex statistics. \emph{Journal Of Applied Statistics}, Vol.38, No.8, pp. 1549-1576,
DOI \doi{10.1080/02664763.2010.515674}.

Anthony B. Atkinson (1987). On the measurement of poverty.
\emph{Econometrica}, Vol.55, No.4, (Jul., 1987), pp. 749-764,
DOI \doi{10.2307/1911028}.

Guillaume Osier (2009). Variance estimation for complex indicators
of poverty and inequality. \emph{Journal of the European Survey Research
Association}, Vol.3, No.3, pp. 167-195,
ISSN 1864-3361, URL \url{https://ojs.ub.uni-konstanz.de/srm/article/view/369}.

Jean-Claude Deville (1999). Variance estimation for complex statistics and estimators:
linearization and residual techniques. Survey Methodology, 25, 193-203,
URL \url{https://www150.statcan.gc.ca/n1/en/catalogue/12-001-X19990024882}.
}
\seealso{
\code{\link{svyarpt}}
}
\author{
Guilherme Jacob, Djalma Pessoa, and Anthony Damico
}
\keyword{survey}
