% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svybmi.R
\name{svybmi}
\alias{svybmi}
\alias{svybmi.survey.design}
\alias{svybmi.svyrep.design}
\alias{svybmi.DBIsvydesign}
\title{Bourguignon (1999) multidimensional inequality indices (EXPERIMENTAL)}
\usage{
svybmi(formula, design, ...)

\method{svybmi}{survey.design}(formula, design, alpha = 0.5, beta = -2,
  dimw = NULL, na.rm = FALSE, ...)

\method{svybmi}{svyrep.design}(formula, design, alpha = 0.5, beta = -2,
  dimw = NULL, na.rm = FALSE, ...)

\method{svybmi}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the variables. Variables can be numeric or ordered factors.}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{alpha}{a scalar defining the exponent of the indicator.}

\item{beta}{a scalar defining the exponent of the indicator.}

\item{dimw}{a vector defining the weight of each dimension in the multidimensional deprivation sum.}

\item{na.rm}{Should cases with missing values be dropped?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate indices from the Bourguignon (1999) class, a class of multidimensional inequality measures.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\note{
This function is experimental and is subject to change in later versions.
}
\examples{
library(survey)
library(vardpoor)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep(des_eusilc)
des_eusilc <- update(des_eusilc, pb220a = ordered( pb220a ) )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap", replicates = 50 )
des_eusilc_rep <- convey_prep(des_eusilc_rep)

# linearized
svybmi(~eqincome+hy050n, design = des_eusilc, alpha = .5, beta = .5, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = des_eusilc, alpha = .5, beta = 0, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = des_eusilc, alpha = .5, beta = -.5, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = des_eusilc, alpha = .5, beta = -1, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = des_eusilc, alpha = .5, beta = -2, na.rm = FALSE )

# replicate
svybmi(~eqincome+hy050n, design = des_eusilc_rep, alpha = .5, beta = .5, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = des_eusilc_rep, alpha = .5, beta = 0, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = des_eusilc_rep, alpha = .5, beta = -.5, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = des_eusilc_rep, alpha = .5, beta = -1, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = des_eusilc_rep, alpha = .5, beta = -2, na.rm = FALSE )

\dontrun{

# database-backed design
library(MonetDBLite)
library(DBI)
dbfolder <- tempdir()
conn <- dbConnect( MonetDBLite::MonetDBLite() , dbfolder )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfolder,
		dbtype="MonetDBLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )

# linearized
svybmi(~eqincome+hy050n, design = dbd_eusilc, alpha = .5, beta = .5, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = dbd_eusilc, alpha = .5, beta = 0, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = dbd_eusilc, alpha = .5, beta = -.5, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = dbd_eusilc, alpha = .5, beta = -1, na.rm = FALSE )
svybmi(~eqincome+hy050n, design = dbd_eusilc, alpha = .5, beta = -2, na.rm = FALSE )

# subsetting:
sub_dbd_eusilc <- subset( dbd_eusilc, db040 == "Styria")
svybmi(~eqincome+hy050n, design = sub_dbd_eusilc, alpha = .5, beta = .5, na.rm = FALSE )

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Francois Bourguignon (1999). Comment to 'Multidimensioned Approaches to Welfare
Analysis' by Maasoumi, E. In: Handbook of income inequality measurement., ed. J.
Silber, Boston, Dordrecht and London: Kluwer Academic, p. 477-484.

Maria Ana Lugo (2007). Comparing multidimensional indices of inequality: Methods and application.
In: Research on Economic Inequality. Emerald, p. 213-236.
}
\seealso{
\code{\link{svyfgt}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
