% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exact_cond_midP_tests_rxc.R
\name{Exact_cond_midP_tests_rxc}
\alias{Exact_cond_midP_tests_rxc}
\title{Exact conditional and mid-P tests for the rxc table}
\usage{
Exact_cond_midP_tests_rxc(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (an rxc matrix)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing exact p-values and mid-p values
}
\description{
Exact conditional and mid-P tests for the rxc table:
the Fisher-Freeman-Halton, Pearson, likelihood ratio, Kruskal-Wallis,
linear-by-linear, and Jonckheere-Terpstra tests.

Described in Chapter 7 "The rxc Table"
}
\note{
Works only for 3x2 and 3x3 tables
}
\examples{
# Treatment for ear infection (Table 7.3)
n <- rbind(c(40, 25), c(54, 7), c(63, 10))
Exact_cond_midP_tests_rxc(n)
# Low birth weight vs psychiatric morbitidy (Table 7.6)
\dontrun{
  n <- matrix(c(22, 4, 12, 24, 9, 10, 51, 7, 6), ncol = 3, byrow=TRUE)
  Exact_cond_midP_tests_rxc(n)
}
}
