% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exact_binomial_test_1x2.R
\name{Exact_binomial_test_1x2}
\alias{Exact_binomial_test_1x2}
\title{The exact binomial test for the binomial probability (pi)}
\usage{
Exact_binomial_test_1x2(X, n, pi0, printresults = TRUE)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{pi0}{a given probability}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
The two-sided, twice-the-smallest tail p-value
}
\description{
H_0 pi = pi0  vs  H_A: pi ~= pi0 (two-sided)

Described in Chapter 2 "The 1x2 Table and the Binomial Distribution"
}
\examples{

# The number of 1st order male births (Singh et al. 2010)
Exact_binomial_test_1x2(X = 250, n = 533, pi0 = 0.513)
# The number of 2nd order male births (Singh et al. 2010)
Exact_binomial_test_1x2(X = 204, n = 412, pi0 = 0.513)
# The number of 3rd order male births (Singh et al. 2010)
Exact_binomial_test_1x2(X = 103, n = 167, pi0 = 0.513)
# The number of 4th order male births (Singh et al. 2010)
Exact_binomial_test_1x2(X = 33, n = 45, pi0 = 0.513)
# Ligarden et al. (2010)
Exact_binomial_test_1x2(X = 13, n = 16, pi0 = 0.5)

}
