% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_list_voice.R
\name{ms_list_voice}
\alias{ms_list_voice}
\title{Get List of Voices for Specified Region}
\usage{
ms_list_voice(api_key = NULL, region = "westus")
}
\arguments{
\item{api_key}{Microsoft Azure Cognitive Services API key}

\item{region}{Subscription region for API key. For more info, see
\url{https://learn.microsoft.com/en-us/azure/cognitive-services/speech-service/regions}}
}
\value{
A \code{data.frame} of the names and their long names.
}
\description{
Obtains a full list of voices for a specific region.
}
\details{
For more info, see \href{https://learn.microsoft.com/en-us/azure/cognitive-services/Speech-Service/rest-text-to-speech?tabs=streaming#get-a-list-of-voices}{Get a list of voices}
from the Microsoft documentation.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# List voices for westus
ms_list_voice(region = "westus")

# List voices for eastus
ms_list_voice(region = "eastus")
\dontshow{\}) # examplesIf}
}
