% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotSamples}
\alias{plotSamples}
\title{Plot panel of specified embeddings, extracting them from pagoda2 objects}
\usage{
plotSamples(
  samples,
  groups = NULL,
  colors = NULL,
  gene = NULL,
  embedding.type = NULL,
  ...
)
}
\arguments{
\item{samples}{list of pagoda2 or Seurat objects}

\item{groups}{vector of cluster labels, names contain cell names (default=NULL)}

\item{colors}{vector of numbers, which must be shown with point colors, names contain cell names (default=NULL). This argument is ignored if groups are provided.}

\item{gene}{gene name (default=NULL). If this parameter is provided, points are colored by expression of this gene.}

\item{embedding.type}{type of embedding (default=NULL). If embedding.type is NULL, this defaults to 'tSNE'. If a matrix is passed, it is interpreted as an actual embedding (then first two columns are interpreted as x/y coordinates, row names must be cell names).}

\item{...}{
  Arguments passed on to \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel}}
  \describe{
    \item{\code{mapping}}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}} or
\code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}
    \item{\code{data}}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}
    \item{\code{stat}}{The statistical transformation to use on the data for this
layer, as a string.}
    \item{\code{position}}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}
    \item{\code{parse}}{If TRUE, the labels will be parsed into expressions and
displayed as described in ?plotmath}
    \item{\code{box.padding}}{Amount of padding around bounding box, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}
    \item{\code{label.padding}}{Amount of padding around label, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}
    \item{\code{point.padding}}{Amount of padding around labeled point, as unit or
number. Defaults to 0. (Default unit is lines, but other units can be
specified by passing \code{unit(x, "units")}).}
    \item{\code{label.r}}{Radius of rounded corners, as unit or number. Defaults
to 0.15. (Default unit is lines, but other units can be specified by
passing \code{unit(x, "units")}).}
    \item{\code{label.size}}{Size of label border, in mm.}
    \item{\code{min.segment.length}}{Skip drawing segments shorter than this, as unit or
number. Defaults to 0.5. (Default unit is lines, but other units can be
specified by passing \code{unit(x, "units")}).}
    \item{\code{arrow}}{specification for arrow heads, as created by \code{\link[grid]{arrow}}}
    \item{\code{force}}{Force of repulsion between overlapping text labels. Defaults
to 1.}
    \item{\code{force_pull}}{Force of attraction between a text label and its
corresponding data point. Defaults to 1.}
    \item{\code{max.time}}{Maximum number of seconds to try to resolve overlaps.
Defaults to 0.5.}
    \item{\code{max.iter}}{Maximum number of iterations to try to resolve overlaps.
Defaults to 10000.}
    \item{\code{max.overlaps}}{Exclude text labels that overlap too many things.
Defaults to 10.}
    \item{\code{nudge_x,nudge_y}}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}
    \item{\code{xlim,ylim}}{Limits for the x and y axes. Text labels will be constrained
to these limits. By default, text labels are constrained to the entire plot
area.}
    \item{\code{na.rm}}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}
    \item{\code{direction}}{"both", "x", or "y" -- direction in which to adjust position of labels}
    \item{\code{seed}}{Random seed passed to \code{\link[base]{set.seed}}. Defaults to
\code{NA}, which means that \code{set.seed} will not be called.}
    \item{\code{verbose}}{If \code{TRUE}, some diagnostics of the repel algorithm are printed}
    \item{\code{inherit.aes}}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
  }}
}
\value{
ggplot2 object with the panel of plots
}
\description{
Plot panel of specified embeddings, extracting them from pagoda2 objects
}
\keyword{internal}
