% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.CFA.R
\name{summary.CFA}
\alias{summary.CFA}
\title{S3 Summary for CFA}
\usage{
\method{summary}{CFA}(
  object,
  digits = 3,
  type = "z.pChi",
  sorton = NULL,
  decreasing = FALSE,
  showall = TRUE,
  holm = FALSE,
  wide = FALSE,
  adjalpha = "bonferroni",
  ...
)
}
\arguments{
\item{object}{object of class\code{"CFA"}}

\item{digits}{integer rounds the values to the specified number of decimal places, default is \code{digits=3}.}

\item{type}{character indicating which test to use for inference whether the observed pattern are 'Types', 'Antitypes' or not significant at all. Possible options for \code{type} are \code{"pChi"}, \code{"ex.bin.test"}, \code{"z.pChi"}, \code{"z.pBin"} and \code{"p.stir"}.}

\item{sorton}{sort results of local test by any column. By default the output is not sorted. Other options may be \code{"pat."}, \code{"obs."}, \code{"exp."}, \code{"Type"}, \code{"Chi"}, etc. ... So all column names that can potentially appear in the result.}

\item{decreasing}{logical. Should the sort be increasing or decreasing? see \code{\link{order}}}

\item{showall}{logical with default \code{showall = TRUE}. To return only significant pattern ('Types' / 'Antitypes') set it to \code{showall = FALSE}.}

\item{holm}{logical with default \code{holm = FALSE}. If set to \code{holm = TRUE}, significance testing is based on the holm procedure -- see references. This argument is deprecated (since version 1.5.6) and kept only for downward compatibility. Use argument \code{adjalpha} for any type of alpha adjustment.}

\item{wide}{logical with default \code{wide = FALSE}. If set to \code{wide = TRUE}, results for all significance tests are returned.}

\item{adjalpha}{character with default \code{adjalpha = "bonferroni"}. Selector for the type of alpha adjustment for multiple testing. Possible options are: \code{adjalpha = "none"}, for no adjustment; \code{adjalpha = "bonferroni"}, for bonferroni adjustment (default); \code{adjalpha = "holm"}, for alpha adjustment according to Holm (1979); other options to come ... .}

\item{...}{other parameters passed trough.}
}
\value{
a summary of the results printed on the console.
}
\description{
S3 summary method for object of class\code{"CFA"}
}
\references{
Holm, S. (1979). A simple sequentially rejective multiple test procedure. \emph{Scandinavian Journal of Statistics, 6}(2), 65–70.

Bonferroni, C. E. (1935). Il calcolo delle assicurazioni su gruppi di teste. In S.O. Carboni (Ed.), \emph{Studi in Onore del Professore Salvatore Ortu Carboni} (S. 13–60). Roma, Tipografia del Senato: Bardi.
}
\keyword{methods}
