% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.CFA.R
\name{summary.CFA}
\alias{summary.CFA}
\title{S3 Summary for CFA}
\usage{
\method{summary}{CFA}(
  object,
  digits = 3,
  type = "z.pChi",
  sorton = NULL,
  decreasing = FALSE,
  showall = TRUE,
  holm = FALSE,
  ...
)
}
\arguments{
\item{object}{object of class\code{"CFA"}}

\item{digits}{integer rounds the values to the specified number of decimal places, default is \code{digits=3}.}

\item{type}{character indicating which test to use for inference wether the observed pattern are 'Types', 'Antitypes' or not significant at all. Possible options for \code{type} are \code{"pChi"}, \code{"ex.bin.test"}, \code{"z.pChi"}, \code{"z.pBin"} and \code{"p.stir"}.}

\item{sorton}{sort results of local test by any column. by default the output is not sorted. Other options may be \code{"pat."}, \code{"obs."}, \code{"exp."}, \code{"Type"}, \code{"Chi"}, etc. ...}

\item{decreasing}{logical. Should the sort be increasing or decreasing? see \code{\link{order}}}

\item{showall}{logical with default \code{showall = TRUE}. To return only significant pattern (types / antitypes) set it to \code{showall = FALSE}.}

\item{holm}{logical with default \code{holm = FALSE}. If set to \code{holm = TRUE}, significance testing is based on the holm procedure -- see references.}

\item{...}{other parameters passed trough}
}
\description{
S3 summary method for object of class\code{"CFA"}
}
\references{
Holm, S. (1979). A simple sequentially rejective multiple test procedure. \emph{Scandinavian Journal of Statistics, 6}(2), 65–70.
}
