\name{triadic}
\alias{triadic}
\title{Triadic Color Scheme}
\description{
Triadic color schemes use colors that are evenly spaced around the color wheel.
}
\usage{
triadic(color, plot = TRUE, bg = "white", labcol = NULL, title = TRUE)
}
\arguments{
  \item{color}{an R color name or a color in hexadecimal notation}
  \item{plot}{logical value indicating whether to plot a color wheel with the generated scheme}
  \item{bg}{background color of the plot. Used only when \code{plot=TRUE}}
  \item{labcol}{color for the labels (i.e. names of the colors). Used only when \code{plot=TRUE}}
  \item{title}{logical value indicating whether to display a title in the plot. Used only when \code{plot=TRUE}}
}
\details{
  The triadic colors are obtained following a color wheel with 12 colors, each one spaced at 30 degrees from each other.

  Triadic color schemes tend to be quite vibrant. To use a triadic harmony successfully, the colors should be carefully balanced letting one color dominate and use the others for accent.
}
\value{
  A character vector with the given color and the triadic colors in hexadecimal notation
}
\author{
  Gaston Sanchez
}
\seealso{
  \code{\link{complementary}}, \code{\link{splitComp}}, \code{\link{adjacent}}, \code{\link{tetradic}}, \code{\link{square}}
}
\examples{
  \dontrun{
  # triadic colors of "tomato"
  triadic("tomato")

  # triadic colors of "tomato" with background color "gray20"
  triadic("tomato", bg="gray20")
  }
}
