% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_selection.R
\name{feat_selection}
\alias{feat_selection}
\title{Adds positive selection to a model}
\usage{
feat_selection(strength_AA, strength_Aa, strength_A, population = 1, time)
}
\arguments{
\item{strength_AA}{The selection strength for the selected homozygote}

\item{strength_Aa}{The selection strength for the heterozygote.}

\item{strength_A}{This sets the strength for the selected allele in an
haploid model. \code{strength_AA} and \code{strength_Aa} are ignored
when this is argument is given.}

\item{population}{The population in which the allele is selected.}

\item{time}{The time at which the selection starts.}
}
\description{
Adds positive selection to a model
}
\examples{
# Positive selection in population 2:
model <- coal_model(c(10, 13), 100) +
  feat_pop_merge(par_range('tau', .1, 2), 2, 1) +
  feat_selection(strength_AA=par_expr(2*s),
                 strength_Aa=par_range('s', 100, 2000),
                 population = 2,
                 time=par_expr(tau))

}

