# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

parse_ms_positions <- function(line) {
    .Call('coala_parse_ms_positions', PACKAGE = 'coala', line)
}

parse_ms_output <- function(file_names, sample_size, loci_number) {
    .Call('coala_parse_ms_output', PACKAGE = 'coala', file_names, sample_size, loci_number)
}

parse_seqgen_output <- function(output, individuals, locus_length, locus_number, outgroup_size, calc_segsites = TRUE) {
    .Call('coala_parse_seqgen_output', PACKAGE = 'coala', output, individuals, locus_length, locus_number, outgroup_size, calc_segsites)
}

generate_trio_trees <- function(trees, llm) {
    .Call('coala_generate_trio_trees', PACKAGE = 'coala', trees, llm)
}

create_segsites <- function(snps, positions = numeric(0), trio_locus = numeric(0), check = TRUE) {
    .Call('coala_create_segsites', PACKAGE = 'coala', snps, positions, trio_locus, check)
}

get_snps <- function(seg_sites) {
    .Call('coala_get_snps', PACKAGE = 'coala', seg_sites)
}

get_positions <- function(seg_sites) {
    .Call('coala_get_positions', PACKAGE = 'coala', seg_sites)
}

set_positions <- function(seg_sites, positions) {
    .Call('coala_set_positions', PACKAGE = 'coala', seg_sites, positions)
}

get_trio_locus <- function(seg_sites) {
    .Call('coala_get_trio_locus', PACKAGE = 'coala', seg_sites)
}

set_trio_locus <- function(seg_sites, trio_locus) {
    .Call('coala_set_trio_locus', PACKAGE = 'coala', seg_sites, trio_locus)
}

calc_four_gamete_stat <- function(seg_sites_list, individuals, locus_length) {
    .Call('coala_calc_four_gamete_stat', PACKAGE = 'coala', seg_sites_list, individuals, locus_length)
}

#' Calculates the JSFS for two populations
#'
#' @param seg_sites_list List of segregating sites
#' @param pop1 The rows of \code{seg_sites} that correspond to individuals
#'   of the first population.
#' @param pop2 same as \code{pop1}, but for the second population.
#' @export
#' @return The Joint Site Frequency Spectrum, as a matrix.
calc_jsfs <- function(seg_sites_list, pop1, pop2) {
    .Call('coala_calc_jsfs', PACKAGE = 'coala', seg_sites_list, pop1, pop2)
}

calc_mcmf <- function(seg_sites, individuals, has_trios = TRUE, ploidy = 1L) {
    .Call('coala_calc_mcmf', PACKAGE = 'coala', seg_sites, individuals, has_trios, ploidy)
}

calc_nucleotide_div <- function(seg_sites, individuals) {
    .Call('coala_calc_nucleotide_div', PACKAGE = 'coala', seg_sites, individuals)
}

unphase_segsites <- function(seg_sites_list, ploidy, samples_per_ind) {
    .Call('coala_unphase_segsites', PACKAGE = 'coala', seg_sites_list, ploidy, samples_per_ind)
}

