/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.fps;

import com.amazonaws.fps.AmazonFPS;
import com.amazonaws.fps.AmazonFPSConfig;
import com.amazonaws.fps.AmazonFPSException;
import com.amazonaws.fps.model.Amount;
import com.amazonaws.fps.model.CancelRequest;
import com.amazonaws.fps.model.CancelResponse;
import com.amazonaws.fps.model.CancelSubscriptionAndRefundRequest;
import com.amazonaws.fps.model.CancelSubscriptionAndRefundResponse;
import com.amazonaws.fps.model.CancelTokenRequest;
import com.amazonaws.fps.model.CancelTokenResponse;
import com.amazonaws.fps.model.DescriptorPolicy;
import com.amazonaws.fps.model.Error;
import com.amazonaws.fps.model.ErrorResponse;
import com.amazonaws.fps.model.FundPrepaidRequest;
import com.amazonaws.fps.model.FundPrepaidResponse;
import com.amazonaws.fps.model.GetAccountActivityRequest;
import com.amazonaws.fps.model.GetAccountActivityResponse;
import com.amazonaws.fps.model.GetAccountBalanceRequest;
import com.amazonaws.fps.model.GetAccountBalanceResponse;
import com.amazonaws.fps.model.GetDebtBalanceRequest;
import com.amazonaws.fps.model.GetDebtBalanceResponse;
import com.amazonaws.fps.model.GetOutstandingDebtBalanceRequest;
import com.amazonaws.fps.model.GetOutstandingDebtBalanceResponse;
import com.amazonaws.fps.model.GetPaymentInstructionRequest;
import com.amazonaws.fps.model.GetPaymentInstructionResponse;
import com.amazonaws.fps.model.GetPrepaidBalanceRequest;
import com.amazonaws.fps.model.GetPrepaidBalanceResponse;
import com.amazonaws.fps.model.GetRecipientVerificationStatusRequest;
import com.amazonaws.fps.model.GetRecipientVerificationStatusResponse;
import com.amazonaws.fps.model.GetSubscriptionDetailsRequest;
import com.amazonaws.fps.model.GetSubscriptionDetailsResponse;
import com.amazonaws.fps.model.GetTokenByCallerRequest;
import com.amazonaws.fps.model.GetTokenByCallerResponse;
import com.amazonaws.fps.model.GetTokenUsageRequest;
import com.amazonaws.fps.model.GetTokenUsageResponse;
import com.amazonaws.fps.model.GetTokensRequest;
import com.amazonaws.fps.model.GetTokensResponse;
import com.amazonaws.fps.model.GetTotalPrepaidLiabilityRequest;
import com.amazonaws.fps.model.GetTotalPrepaidLiabilityResponse;
import com.amazonaws.fps.model.GetTransactionRequest;
import com.amazonaws.fps.model.GetTransactionResponse;
import com.amazonaws.fps.model.GetTransactionStatusRequest;
import com.amazonaws.fps.model.GetTransactionStatusResponse;
import com.amazonaws.fps.model.GetTransactionsForSubscriptionRequest;
import com.amazonaws.fps.model.GetTransactionsForSubscriptionResponse;
import com.amazonaws.fps.model.InstallPaymentInstructionRequest;
import com.amazonaws.fps.model.InstallPaymentInstructionResponse;
import com.amazonaws.fps.model.PayRequest;
import com.amazonaws.fps.model.PayResponse;
import com.amazonaws.fps.model.RefundRequest;
import com.amazonaws.fps.model.RefundResponse;
import com.amazonaws.fps.model.ReserveRequest;
import com.amazonaws.fps.model.ReserveResponse;
import com.amazonaws.fps.model.SettleDebtRequest;
import com.amazonaws.fps.model.SettleDebtResponse;
import com.amazonaws.fps.model.SettleRequest;
import com.amazonaws.fps.model.SettleResponse;
import com.amazonaws.fps.model.TransactionalRole;
import com.amazonaws.fps.model.VerifySignatureRequest;
import com.amazonaws.fps.model.VerifySignatureResponse;
import com.amazonaws.fps.model.WriteOffDebtRequest;
import com.amazonaws.fps.model.WriteOffDebtResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonFPSClient
implements AmazonFPS {
    private final Log log = LogFactory.getLog(AmazonFPSClient.class);
    private String awsAccessKeyId = null;
    private String awsSecretAccessKey = null;
    private AmazonFPSConfig config = null;
    private HttpClient httpClient = null;
    private static JAXBContext jaxbContext;
    private static ThreadLocal<Unmarshaller> unmarshaller;
    private static Pattern ERROR_PATTERN_ONE;
    private static Pattern ERROR_PATTERN_TWO;
    private static String DEFAULT_ENCODING;

    public AmazonFPSClient(String awsAccessKeyId, String awsSecretAccessKey) {
        this(awsAccessKeyId, awsSecretAccessKey, new AmazonFPSConfig());
    }

    public AmazonFPSClient(String awsAccessKeyId, String awsSecretAccessKey, AmazonFPSConfig config) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = awsSecretAccessKey;
        this.config = config;
        this.httpClient = this.configureHttpClient();
    }

    @Override
    public CancelTokenResponse cancelToken(CancelTokenRequest request) throws AmazonFPSException {
        return this.invoke(CancelTokenResponse.class, this.convertCancelToken(request));
    }

    @Override
    public CancelResponse cancel(CancelRequest request) throws AmazonFPSException {
        return this.invoke(CancelResponse.class, this.convertCancel(request));
    }

    @Override
    public FundPrepaidResponse fundPrepaid(FundPrepaidRequest request) throws AmazonFPSException {
        return this.invoke(FundPrepaidResponse.class, this.convertFundPrepaid(request));
    }

    @Override
    public GetAccountActivityResponse getAccountActivity(GetAccountActivityRequest request) throws AmazonFPSException {
        return this.invoke(GetAccountActivityResponse.class, this.convertGetAccountActivity(request));
    }

    @Override
    public GetAccountBalanceResponse getAccountBalance(GetAccountBalanceRequest request) throws AmazonFPSException {
        return this.invoke(GetAccountBalanceResponse.class, this.convertGetAccountBalance(request));
    }

    @Override
    public GetTransactionsForSubscriptionResponse getTransactionsForSubscription(GetTransactionsForSubscriptionRequest request) throws AmazonFPSException {
        return this.invoke(GetTransactionsForSubscriptionResponse.class, this.convertGetTransactionsForSubscription(request));
    }

    @Override
    public GetSubscriptionDetailsResponse getSubscriptionDetails(GetSubscriptionDetailsRequest request) throws AmazonFPSException {
        return this.invoke(GetSubscriptionDetailsResponse.class, this.convertGetSubscriptionDetails(request));
    }

    @Override
    public GetDebtBalanceResponse getDebtBalance(GetDebtBalanceRequest request) throws AmazonFPSException {
        return this.invoke(GetDebtBalanceResponse.class, this.convertGetDebtBalance(request));
    }

    @Override
    public GetOutstandingDebtBalanceResponse getOutstandingDebtBalance(GetOutstandingDebtBalanceRequest request) throws AmazonFPSException {
        return this.invoke(GetOutstandingDebtBalanceResponse.class, this.convertGetOutstandingDebtBalance(request));
    }

    @Override
    public GetPrepaidBalanceResponse getPrepaidBalance(GetPrepaidBalanceRequest request) throws AmazonFPSException {
        return this.invoke(GetPrepaidBalanceResponse.class, this.convertGetPrepaidBalance(request));
    }

    @Override
    public GetTokenByCallerResponse getTokenByCaller(GetTokenByCallerRequest request) throws AmazonFPSException {
        return this.invoke(GetTokenByCallerResponse.class, this.convertGetTokenByCaller(request));
    }

    @Override
    public CancelSubscriptionAndRefundResponse cancelSubscriptionAndRefund(CancelSubscriptionAndRefundRequest request) throws AmazonFPSException {
        return this.invoke(CancelSubscriptionAndRefundResponse.class, this.convertCancelSubscriptionAndRefund(request));
    }

    @Override
    public GetTokenUsageResponse getTokenUsage(GetTokenUsageRequest request) throws AmazonFPSException {
        return this.invoke(GetTokenUsageResponse.class, this.convertGetTokenUsage(request));
    }

    @Override
    public GetTokensResponse getTokens(GetTokensRequest request) throws AmazonFPSException {
        return this.invoke(GetTokensResponse.class, this.convertGetTokens(request));
    }

    @Override
    public GetTotalPrepaidLiabilityResponse getTotalPrepaidLiability(GetTotalPrepaidLiabilityRequest request) throws AmazonFPSException {
        return this.invoke(GetTotalPrepaidLiabilityResponse.class, this.convertGetTotalPrepaidLiability(request));
    }

    @Override
    public GetTransactionResponse getTransaction(GetTransactionRequest request) throws AmazonFPSException {
        return this.invoke(GetTransactionResponse.class, this.convertGetTransaction(request));
    }

    @Override
    public GetTransactionStatusResponse getTransactionStatus(GetTransactionStatusRequest request) throws AmazonFPSException {
        return this.invoke(GetTransactionStatusResponse.class, this.convertGetTransactionStatus(request));
    }

    @Override
    public GetPaymentInstructionResponse getPaymentInstruction(GetPaymentInstructionRequest request) throws AmazonFPSException {
        return this.invoke(GetPaymentInstructionResponse.class, this.convertGetPaymentInstruction(request));
    }

    @Override
    public InstallPaymentInstructionResponse installPaymentInstruction(InstallPaymentInstructionRequest request) throws AmazonFPSException {
        return this.invoke(InstallPaymentInstructionResponse.class, this.convertInstallPaymentInstruction(request));
    }

    @Override
    public PayResponse pay(PayRequest request) throws AmazonFPSException {
        return this.invoke(PayResponse.class, this.convertPay(request));
    }

    @Override
    public RefundResponse refund(RefundRequest request) throws AmazonFPSException {
        return this.invoke(RefundResponse.class, this.convertRefund(request));
    }

    @Override
    public ReserveResponse reserve(ReserveRequest request) throws AmazonFPSException {
        return this.invoke(ReserveResponse.class, this.convertReserve(request));
    }

    @Override
    public SettleResponse settle(SettleRequest request) throws AmazonFPSException {
        return this.invoke(SettleResponse.class, this.convertSettle(request));
    }

    @Override
    public SettleDebtResponse settleDebt(SettleDebtRequest request) throws AmazonFPSException {
        return this.invoke(SettleDebtResponse.class, this.convertSettleDebt(request));
    }

    @Override
    public WriteOffDebtResponse writeOffDebt(WriteOffDebtRequest request) throws AmazonFPSException {
        return this.invoke(WriteOffDebtResponse.class, this.convertWriteOffDebt(request));
    }

    @Override
    public GetRecipientVerificationStatusResponse getRecipientVerificationStatus(GetRecipientVerificationStatusRequest request) throws AmazonFPSException {
        return this.invoke(GetRecipientVerificationStatusResponse.class, this.convertGetRecipientVerificationStatus(request));
    }

    @Override
    public VerifySignatureResponse verifySignature(VerifySignatureRequest request) throws AmazonFPSException {
        return this.invoke(VerifySignatureResponse.class, this.convertVerifySignature(request));
    }

    private HttpClient configureHttpClient() {
        HttpClientParams httpClientParams = new HttpClientParams();
        httpClientParams.setParameter("http.useragent", (Object)this.config.getUserAgent());
        httpClientParams.setParameter("http.method.retry-handler", (Object)new HttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                if (executionCount > 3) {
                    AmazonFPSClient.this.log.debug((Object)"Maximum Number of Retry attempts reached, will not retry");
                    return false;
                }
                AmazonFPSClient.this.log.debug((Object)("Retrying request. Attempt " + executionCount));
                if (exception instanceof NoHttpResponseException) {
                    AmazonFPSClient.this.log.debug((Object)"Retrying on NoHttpResponseException");
                    return true;
                }
                if (exception instanceof InterruptedIOException) {
                    AmazonFPSClient.this.log.debug((Object)"Will not retry on InterruptedIOException", (Throwable)exception);
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    AmazonFPSClient.this.log.debug((Object)"Will not retry on UnknownHostException", (Throwable)exception);
                    return false;
                }
                if (!method.isRequestSent()) {
                    AmazonFPSClient.this.log.debug((Object)"Retrying on failed sent request");
                    return true;
                }
                return false;
            }
        });
        HostConfiguration hostConfiguration = new HostConfiguration();
        HttpConnectionManagerParams connectionManagerParams = new HttpConnectionManagerParams();
        connectionManagerParams.setConnectionTimeout(50000);
        connectionManagerParams.setSoTimeout(50000);
        connectionManagerParams.setStaleCheckingEnabled(true);
        connectionManagerParams.setTcpNoDelay(true);
        connectionManagerParams.setMaxTotalConnections(this.config.getMaxConnections());
        connectionManagerParams.setMaxConnectionsPerHost(hostConfiguration, this.config.getMaxConnections());
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(connectionManagerParams);
        this.httpClient = new HttpClient(httpClientParams, (HttpConnectionManager)connectionManager);
        if (this.config.isSetProxyHost() && this.config.isSetProxyPort()) {
            this.log.info((Object)("Configuring Proxy. Proxy Host: " + this.config.getProxyHost() + "Proxy Port: " + this.config.getProxyPort()));
            hostConfiguration.setProxy(this.config.getProxyHost(), this.config.getProxyPort());
            if (this.config.isSetProxyUsername() && this.config.isSetProxyPassword()) {
                this.httpClient.getState().setProxyCredentials(new AuthScope(this.config.getProxyHost(), this.config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(this.config.getProxyUsername(), this.config.getProxyPassword()));
            }
        }
        this.httpClient.setHostConfiguration(hostConfiguration);
        return this.httpClient;
    }

    private <T> T invoke(Class<T> clazz, Map<String, String> parameters) throws AmazonFPSException {
        String actionName = parameters.get("Action");
        T response = null;
        String responseBodyString = null;
        PostMethod method = new PostMethod(this.config.getServiceURL());
        int status = -1;
        this.log.debug((Object)("Invoking" + actionName + " request. Current parameters: " + parameters));
        try {
            this.log.debug((Object)("Setting content-type to application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase()));
            method.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase());
            this.log.debug((Object)"Adding required parameters...");
            this.addRequiredParametersToRequest(method, parameters);
            this.log.debug((Object)("Done adding additional required parameteres. Parameters now: " + parameters));
            boolean shouldRetry = true;
            int retries = 0;
            do {
                this.log.debug((Object)("Sending Request to host:  " + this.config.getServiceURL()));
                try {
                    status = this.httpClient.executeMethod((HttpMethod)method);
                    responseBodyString = this.getResponsBodyAsString(method.getResponseBodyAsStream());
                    if (status == 200) {
                        shouldRetry = false;
                        this.log.debug((Object)("Received Response. Status: " + status + ". " + "Response Body: " + responseBodyString));
                        this.log.debug((Object)("Attempting to unmarshal into the " + actionName + "Response type..."));
                        response = clazz.cast(this.getUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(responseBodyString))));
                        this.log.debug((Object)("Unmarshalled response into " + actionName + "Response type."));
                        continue;
                    }
                    this.log.debug((Object)("Received Response. Status: " + status + ". " + "Response Body: " + responseBodyString));
                    if ((status == 500 || status == 503) && this.pauseIfRetryNeeded(++retries)) {
                        shouldRetry = true;
                        continue;
                    }
                    this.log.debug((Object)"Attempting to unmarshal into the ErrorResponse type...");
                    ErrorResponse errorResponse = (ErrorResponse)this.getUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(responseBodyString)));
                    this.log.debug((Object)"Unmarshalled response into the ErrorResponse type.");
                    Error error = errorResponse.getError().get(0);
                    throw new AmazonFPSException(error.getMessage(), status, error.getCode(), error.getType(), errorResponse.getRequestId(), errorResponse.toXML());
                }
                catch (JAXBException je) {
                    this.log.debug((Object)"Caught JAXBException", (Throwable)je);
                    this.log.debug((Object)("Response cannot be unmarshalled neither as " + actionName + "Response or ErrorResponse types." + "Checking for other possible errors."));
                    AmazonFPSException awse = this.processErrors(responseBodyString, status);
                    throw awse;
                }
                catch (IOException ioe) {
                    this.log.debug((Object)"Caught IOException exception", (Throwable)ioe);
                    throw new AmazonFPSException("Internal Error", ioe);
                }
                catch (Exception e) {
                    this.log.debug((Object)"Caught Exception", (Throwable)e);
                    throw new AmazonFPSException(e);
                }
                finally {
                    method.releaseConnection();
                }
            } while (shouldRetry);
        }
        catch (AmazonFPSException se) {
            this.log.debug((Object)"Caught AmazonFPSException", (Throwable)se);
            throw se;
        }
        catch (Throwable t) {
            this.log.debug((Object)"Caught Exception", t);
            throw new AmazonFPSException(t);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponsBodyAsString(InputStream input) throws IOException {
        String responsBodyString = null;
        try {
            int len;
            InputStreamReader reader = new InputStreamReader(input, DEFAULT_ENCODING);
            StringBuilder b = new StringBuilder();
            char[] c = new char[1024];
            while (0 < (len = reader.read(c))) {
                b.append(c, 0, len);
            }
            responsBodyString = b.toString();
        }
        finally {
            input.close();
        }
        return responsBodyString;
    }

    private boolean pauseIfRetryNeeded(int retries) throws InterruptedException {
        if (retries <= this.config.getMaxErrorRetry()) {
            long delay = (long)(Math.pow(4.0, retries) * 100.0);
            this.log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt numer: " + retries));
            Thread.sleep(delay);
            return true;
        }
        return false;
    }

    private void addRequiredParametersToRequest(PostMethod method, Map<String, String> parameters) throws SignatureException {
        parameters.put("Version", this.config.getServiceVersion());
        parameters.put("SignatureVersion", this.config.getSignatureVersion());
        parameters.put("Timestamp", this.getFormattedTimestamp());
        parameters.put("AWSAccessKeyId", this.awsAccessKeyId);
        parameters.put("Signature", this.signParameters(parameters, this.awsSecretAccessKey));
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            method.addParameter(entry.getKey(), entry.getValue());
        }
    }

    private AmazonFPSException processErrors(String responseString, int status) {
        AmazonFPSException ex = null;
        Matcher matcher = null;
        if (responseString != null && responseString.startsWith("<")) {
            matcher = ERROR_PATTERN_ONE.matcher(responseString);
            if (matcher.matches()) {
                ex = new AmazonFPSException(matcher.group(3), status, matcher.group(2), "Unknown", matcher.group(1), responseString);
            } else {
                matcher = ERROR_PATTERN_TWO.matcher(responseString);
                if (matcher.matches()) {
                    ex = new AmazonFPSException(matcher.group(2), status, matcher.group(1), "Unknown", matcher.group(4), responseString);
                } else {
                    ex = new AmazonFPSException("Internal Error", status);
                    this.log.debug((Object)("Service Error. Response Status: " + status));
                }
            }
        } else {
            ex = new AmazonFPSException("Internal Error", status);
            this.log.debug((Object)("Service Error. Response Status: " + status));
        }
        return ex;
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(new Date());
    }

    private String signParameters(Map<String, String> parameters, String key) throws SignatureException {
        String signatureVersion = parameters.get("SignatureVersion");
        String algorithm = "HmacSHA1";
        String stringToSign = null;
        if (!"2".equals(signatureVersion)) {
            throw new SignatureException("Invalid Signature Version specified");
        }
        algorithm = this.config.getSignatureMethod();
        parameters.put("SignatureMethod", algorithm);
        stringToSign = this.calculateStringToSignV2(parameters);
        this.log.debug((Object)("Calculated string to sign: " + stringToSign));
        return this.sign(stringToSign, key, algorithm);
    }

    private String calculateStringToSignV2(Map<String, String> parameters) throws SignatureException {
        StringBuilder data = new StringBuilder();
        data.append("POST");
        data.append("\n");
        URI endpoint = null;
        try {
            endpoint = new URI(this.config.getServiceURL().toLowerCase());
        }
        catch (URISyntaxException ex) {
            this.log.debug((Object)"URI Syntax Exception", (Throwable)ex);
            throw new SignatureException("URI Syntax Exception thrown while constructing string to sign", ex);
        }
        data.append(endpoint.getHost());
        data.append("\n");
        String uri = endpoint.getPath();
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        data.append(this.urlEncode(uri, true));
        data.append("\n");
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(parameters);
        Iterator pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry pair = pairs.next();
            String key = (String)pair.getKey();
            data.append(this.urlEncode(key, false));
            data.append("=");
            String value = (String)pair.getValue();
            data.append(this.urlEncode(value, false));
            if (!pairs.hasNext()) continue;
            data.append("&");
        }
        return data.toString();
    }

    private String urlEncode(String value, boolean path) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, DEFAULT_ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            if (path) {
                encoded = encoded.replace("%2F", "/");
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.log.debug((Object)"Unsupported Encoding Exception", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return encoded;
    }

    private String sign(String data, String key, String algorithm) throws SignatureException {
        byte[] signature;
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.getBytes(), algorithm));
            signature = Base64.encodeBase64((byte[])mac.doFinal(data.getBytes(DEFAULT_ENCODING)));
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate signature: " + e.getMessage(), e);
        }
        return new String(signature);
    }

    private Unmarshaller getUnmarshaller() {
        return unmarshaller.get();
    }

    private Map<String, String> convertCancel(CancelRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "Cancel");
        if (request.isSetTransactionId()) {
            params.put("TransactionId", request.getTransactionId());
        }
        if (request.isSetDescription()) {
            params.put("Description", request.getDescription());
        }
        if (request.isSetOverrideIPNURL()) {
            params.put("OverrideIPNURL", request.getOverrideIPNURL());
        }
        return params;
    }

    private Map<String, String> convertCancelToken(CancelTokenRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "CancelToken");
        if (request.isSetTokenId()) {
            params.put("TokenId", request.getTokenId());
        }
        if (request.isSetReasonText()) {
            params.put("ReasonText", request.getReasonText());
        }
        if (request.isSetOverrideIPNURL()) {
            params.put("OverrideIPNURL", request.getOverrideIPNURL());
        }
        return params;
    }

    private Map<String, String> convertCancelSubscriptionAndRefund(CancelSubscriptionAndRefundRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "CancelSubscriptionAndRefund");
        if (request.isSetSubscriptionId()) {
            params.put("SubscriptionId", request.getSubscriptionId());
        }
        if (request.isSetRefundAmount()) {
            Amount refundAmount = request.getRefundAmount();
            if (refundAmount.isSetCurrencyCode()) {
                params.put("RefundAmount.CurrencyCode", refundAmount.getCurrencyCode().value());
            }
            if (refundAmount.isSetValue()) {
                params.put("RefundAmount.Value", refundAmount.getValue());
            }
        }
        if (request.isSetCallerReference()) {
            params.put("CallerReference", request.getCallerReference());
        }
        if (request.isSetCancelReason()) {
            params.put("CancelReason", request.getCancelReason());
        }
        return params;
    }

    private Map<String, String> convertFundPrepaid(FundPrepaidRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "FundPrepaid");
        if (request.isSetSenderTokenId()) {
            params.put("SenderTokenId", request.getSenderTokenId());
        }
        if (request.isSetPrepaidInstrumentId()) {
            params.put("PrepaidInstrumentId", request.getPrepaidInstrumentId());
        }
        if (request.isSetFundingAmount()) {
            Amount fundingAmount = request.getFundingAmount();
            if (fundingAmount.isSetCurrencyCode()) {
                params.put("FundingAmount.CurrencyCode", fundingAmount.getCurrencyCode().value());
            }
            if (fundingAmount.isSetValue()) {
                params.put("FundingAmount.Value", fundingAmount.getValue());
            }
        }
        if (request.isSetCallerReference()) {
            params.put("CallerReference", request.getCallerReference());
        }
        if (request.isSetSenderDescription()) {
            params.put("SenderDescription", request.getSenderDescription());
        }
        if (request.isSetCallerDescription()) {
            params.put("CallerDescription", request.getCallerDescription());
        }
        if (request.isSetDescriptorPolicy()) {
            DescriptorPolicy descriptorPolicy = request.getDescriptorPolicy();
            if (descriptorPolicy.isSetSoftDescriptorType()) {
                params.put("DescriptorPolicy.SoftDescriptorType", descriptorPolicy.getSoftDescriptorType().value());
            }
            if (descriptorPolicy.isSetCSOwner()) {
                params.put("DescriptorPolicy.CSOwner", descriptorPolicy.getCSOwner().value());
            }
        }
        if (request.isSetTransactionTimeoutInMins()) {
            params.put("TransactionTimeoutInMins", request.getTransactionTimeoutInMins() + "");
        }
        if (request.isSetOverrideIPNURL()) {
            params.put("OverrideIPNURL", request.getOverrideIPNURL());
        }
        return params;
    }

    private Map<String, String> convertGetAccountActivity(GetAccountActivityRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetAccountActivity");
        if (request.isSetMaxBatchSize()) {
            params.put("MaxBatchSize", request.getMaxBatchSize() + "");
        }
        if (request.isSetStartDate()) {
            params.put("StartDate", request.getStartDate() + "");
        }
        if (request.isSetEndDate()) {
            params.put("EndDate", request.getEndDate() + "");
        }
        if (request.isSetSortOrderByDate()) {
            params.put("SortOrderByDate", request.getSortOrderByDate().value());
        }
        if (request.isSetFPSOperation()) {
            params.put("FPSOperation", request.getFPSOperation().value());
        }
        if (request.isSetPaymentMethod()) {
            params.put("PaymentMethod", request.getPaymentMethod().value());
        }
        List<TransactionalRole> roleList = request.getRole();
        int roleListIndex = 1;
        for (TransactionalRole role : roleList) {
            params.put("Role." + roleListIndex, role.value());
            ++roleListIndex;
        }
        if (request.isSetTransactionStatus()) {
            params.put("TransactionStatus", request.getTransactionStatus().value());
        }
        return params;
    }

    private Map<String, String> convertGetAccountBalance(GetAccountBalanceRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetAccountBalance");
        return params;
    }

    private Map<String, String> convertGetTransactionsForSubscription(GetTransactionsForSubscriptionRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetTransactionsForSubscription");
        if (request.isSetSubscriptionId()) {
            params.put("SubscriptionId", request.getSubscriptionId());
        }
        return params;
    }

    private Map<String, String> convertGetSubscriptionDetails(GetSubscriptionDetailsRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetSubscriptionDetails");
        if (request.isSetSubscriptionId()) {
            params.put("SubscriptionId", request.getSubscriptionId());
        }
        return params;
    }

    private Map<String, String> convertGetDebtBalance(GetDebtBalanceRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetDebtBalance");
        if (request.isSetCreditInstrumentId()) {
            params.put("CreditInstrumentId", request.getCreditInstrumentId());
        }
        return params;
    }

    private Map<String, String> convertGetOutstandingDebtBalance(GetOutstandingDebtBalanceRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetOutstandingDebtBalance");
        return params;
    }

    private Map<String, String> convertGetPrepaidBalance(GetPrepaidBalanceRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetPrepaidBalance");
        if (request.isSetPrepaidInstrumentId()) {
            params.put("PrepaidInstrumentId", request.getPrepaidInstrumentId());
        }
        return params;
    }

    private Map<String, String> convertGetTokenByCaller(GetTokenByCallerRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetTokenByCaller");
        if (request.isSetTokenId()) {
            params.put("TokenId", request.getTokenId());
        }
        if (request.isSetCallerReference()) {
            params.put("CallerReference", request.getCallerReference());
        }
        return params;
    }

    private Map<String, String> convertGetTokenUsage(GetTokenUsageRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetTokenUsage");
        if (request.isSetTokenId()) {
            params.put("TokenId", request.getTokenId());
        }
        return params;
    }

    private Map<String, String> convertGetTokens(GetTokensRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetTokens");
        if (request.isSetTokenStatus()) {
            params.put("TokenStatus", request.getTokenStatus().value());
        }
        if (request.isSetTokenType()) {
            params.put("TokenType", request.getTokenType().value());
        }
        if (request.isSetCallerReference()) {
            params.put("CallerReference", request.getCallerReference());
        }
        if (request.isSetTokenFriendlyName()) {
            params.put("TokenFriendlyName", request.getTokenFriendlyName());
        }
        return params;
    }

    private Map<String, String> convertGetTotalPrepaidLiability(GetTotalPrepaidLiabilityRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetTotalPrepaidLiability");
        return params;
    }

    private Map<String, String> convertGetTransaction(GetTransactionRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetTransaction");
        if (request.isSetTransactionId()) {
            params.put("TransactionId", request.getTransactionId());
        }
        return params;
    }

    private Map<String, String> convertGetTransactionStatus(GetTransactionStatusRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetTransactionStatus");
        if (request.isSetTransactionId()) {
            params.put("TransactionId", request.getTransactionId());
        }
        return params;
    }

    private Map<String, String> convertGetPaymentInstruction(GetPaymentInstructionRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetPaymentInstruction");
        if (request.isSetTokenId()) {
            params.put("TokenId", request.getTokenId());
        }
        return params;
    }

    private Map<String, String> convertInstallPaymentInstruction(InstallPaymentInstructionRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "InstallPaymentInstruction");
        if (request.isSetPaymentInstruction()) {
            params.put("PaymentInstruction", request.getPaymentInstruction());
        }
        if (request.isSetTokenFriendlyName()) {
            params.put("TokenFriendlyName", request.getTokenFriendlyName());
        }
        if (request.isSetCallerReference()) {
            params.put("CallerReference", request.getCallerReference());
        }
        if (request.isSetTokenType()) {
            params.put("TokenType", request.getTokenType().value());
        }
        if (request.isSetPaymentReason()) {
            params.put("PaymentReason", request.getPaymentReason());
        }
        return params;
    }

    private Map<String, String> convertPay(PayRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "Pay");
        if (request.isSetSenderTokenId()) {
            params.put("SenderTokenId", request.getSenderTokenId());
        }
        if (request.isSetRecipientTokenId()) {
            params.put("RecipientTokenId", request.getRecipientTokenId());
        }
        if (request.isSetTransactionAmount()) {
            Amount transactionAmount = request.getTransactionAmount();
            if (transactionAmount.isSetCurrencyCode()) {
                params.put("TransactionAmount.CurrencyCode", transactionAmount.getCurrencyCode().value());
            }
            if (transactionAmount.isSetValue()) {
                params.put("TransactionAmount.Value", transactionAmount.getValue());
            }
        }
        if (request.isSetChargeFeeTo()) {
            params.put("ChargeFeeTo", request.getChargeFeeTo().value());
        }
        if (request.isSetCallerReference()) {
            params.put("CallerReference", request.getCallerReference());
        }
        if (request.isSetCallerDescription()) {
            params.put("CallerDescription", request.getCallerDescription());
        }
        if (request.isSetSenderDescription()) {
            params.put("SenderDescription", request.getSenderDescription());
        }
        if (request.isSetDescriptorPolicy()) {
            DescriptorPolicy descriptorPolicy = request.getDescriptorPolicy();
            if (descriptorPolicy.isSetSoftDescriptorType()) {
                params.put("DescriptorPolicy.SoftDescriptorType", descriptorPolicy.getSoftDescriptorType().value());
            }
            if (descriptorPolicy.isSetCSOwner()) {
                params.put("DescriptorPolicy.CSOwner", descriptorPolicy.getCSOwner().value());
            }
        }
        if (request.isSetTransactionTimeoutInMins()) {
            params.put("TransactionTimeoutInMins", request.getTransactionTimeoutInMins() + "");
        }
        if (request.isSetMarketplaceFixedFee()) {
            Amount marketplaceFixedFee = request.getMarketplaceFixedFee();
            if (marketplaceFixedFee.isSetCurrencyCode()) {
                params.put("MarketplaceFixedFee.CurrencyCode", marketplaceFixedFee.getCurrencyCode().value());
            }
            if (marketplaceFixedFee.isSetValue()) {
                params.put("MarketplaceFixedFee.Value", marketplaceFixedFee.getValue());
            }
        }
        if (request.isSetMarketplaceVariableFee()) {
            params.put("MarketplaceVariableFee", request.getMarketplaceVariableFee() + "");
        }
        if (request.isSetOverrideIPNURL()) {
            params.put("OverrideIPNURL", request.getOverrideIPNURL());
        }
        return params;
    }

    private Map<String, String> convertRefund(RefundRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "Refund");
        if (request.isSetTransactionId()) {
            params.put("TransactionId", request.getTransactionId());
        }
        if (request.isSetRefundAmount()) {
            Amount refundAmount = request.getRefundAmount();
            if (refundAmount.isSetCurrencyCode()) {
                params.put("RefundAmount.CurrencyCode", refundAmount.getCurrencyCode().value());
            }
            if (refundAmount.isSetValue()) {
                params.put("RefundAmount.Value", refundAmount.getValue());
            }
        }
        if (request.isSetCallerReference()) {
            params.put("CallerReference", request.getCallerReference());
        }
        if (request.isSetCallerDescription()) {
            params.put("CallerDescription", request.getCallerDescription());
        }
        if (request.isSetMarketplaceRefundPolicy()) {
            params.put("MarketplaceRefundPolicy", request.getMarketplaceRefundPolicy().value());
        }
        if (request.isSetOverrideIPNURL()) {
            params.put("OverrideIPNURL", request.getOverrideIPNURL());
        }
        return params;
    }

    private Map<String, String> convertReserve(ReserveRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "Reserve");
        if (request.isSetSenderTokenId()) {
            params.put("SenderTokenId", request.getSenderTokenId());
        }
        if (request.isSetRecipientTokenId()) {
            params.put("RecipientTokenId", request.getRecipientTokenId());
        }
        if (request.isSetTransactionAmount()) {
            Amount transactionAmount = request.getTransactionAmount();
            if (transactionAmount.isSetCurrencyCode()) {
                params.put("TransactionAmount.CurrencyCode", transactionAmount.getCurrencyCode().value());
            }
            if (transactionAmount.isSetValue()) {
                params.put("TransactionAmount.Value", transactionAmount.getValue());
            }
        }
        if (request.isSetChargeFeeTo()) {
            params.put("ChargeFeeTo", request.getChargeFeeTo().value());
        }
        if (request.isSetCallerReference()) {
            params.put("CallerReference", request.getCallerReference());
        }
        if (request.isSetCallerDescription()) {
            params.put("CallerDescription", request.getCallerDescription());
        }
        if (request.isSetSenderDescription()) {
            params.put("SenderDescription", request.getSenderDescription());
        }
        if (request.isSetDescriptorPolicy()) {
            DescriptorPolicy descriptorPolicy = request.getDescriptorPolicy();
            if (descriptorPolicy.isSetSoftDescriptorType()) {
                params.put("DescriptorPolicy.SoftDescriptorType", descriptorPolicy.getSoftDescriptorType().value());
            }
            if (descriptorPolicy.isSetCSOwner()) {
                params.put("DescriptorPolicy.CSOwner", descriptorPolicy.getCSOwner().value());
            }
        }
        if (request.isSetTransactionTimeoutInMins()) {
            params.put("TransactionTimeoutInMins", request.getTransactionTimeoutInMins() + "");
        }
        if (request.isSetMarketplaceFixedFee()) {
            Amount marketplaceFixedFee = request.getMarketplaceFixedFee();
            if (marketplaceFixedFee.isSetCurrencyCode()) {
                params.put("MarketplaceFixedFee.CurrencyCode", marketplaceFixedFee.getCurrencyCode().value());
            }
            if (marketplaceFixedFee.isSetValue()) {
                params.put("MarketplaceFixedFee.Value", marketplaceFixedFee.getValue());
            }
        }
        if (request.isSetMarketplaceVariableFee()) {
            params.put("MarketplaceVariableFee", request.getMarketplaceVariableFee() + "");
        }
        if (request.isSetOverrideIPNURL()) {
            params.put("OverrideIPNURL", request.getOverrideIPNURL());
        }
        return params;
    }

    private Map<String, String> convertSettle(SettleRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "Settle");
        if (request.isSetReserveTransactionId()) {
            params.put("ReserveTransactionId", request.getReserveTransactionId());
        }
        if (request.isSetTransactionAmount()) {
            Amount transactionAmount = request.getTransactionAmount();
            if (transactionAmount.isSetCurrencyCode()) {
                params.put("TransactionAmount.CurrencyCode", transactionAmount.getCurrencyCode().value());
            }
            if (transactionAmount.isSetValue()) {
                params.put("TransactionAmount.Value", transactionAmount.getValue());
            }
        }
        if (request.isSetOverrideIPNURL()) {
            params.put("OverrideIPNURL", request.getOverrideIPNURL());
        }
        return params;
    }

    private Map<String, String> convertSettleDebt(SettleDebtRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "SettleDebt");
        if (request.isSetSenderTokenId()) {
            params.put("SenderTokenId", request.getSenderTokenId());
        }
        if (request.isSetCreditInstrumentId()) {
            params.put("CreditInstrumentId", request.getCreditInstrumentId());
        }
        if (request.isSetSettlementAmount()) {
            Amount settlementAmount = request.getSettlementAmount();
            if (settlementAmount.isSetCurrencyCode()) {
                params.put("SettlementAmount.CurrencyCode", settlementAmount.getCurrencyCode().value());
            }
            if (settlementAmount.isSetValue()) {
                params.put("SettlementAmount.Value", settlementAmount.getValue());
            }
        }
        if (request.isSetCallerReference()) {
            params.put("CallerReference", request.getCallerReference());
        }
        if (request.isSetSenderDescription()) {
            params.put("SenderDescription", request.getSenderDescription());
        }
        if (request.isSetCallerDescription()) {
            params.put("CallerDescription", request.getCallerDescription());
        }
        if (request.isSetDescriptorPolicy()) {
            DescriptorPolicy descriptorPolicy = request.getDescriptorPolicy();
            if (descriptorPolicy.isSetSoftDescriptorType()) {
                params.put("DescriptorPolicy.SoftDescriptorType", descriptorPolicy.getSoftDescriptorType().value());
            }
            if (descriptorPolicy.isSetCSOwner()) {
                params.put("DescriptorPolicy.CSOwner", descriptorPolicy.getCSOwner().value());
            }
        }
        if (request.isSetTransactionTimeoutInMins()) {
            params.put("TransactionTimeoutInMins", request.getTransactionTimeoutInMins() + "");
        }
        if (request.isSetOverrideIPNURL()) {
            params.put("OverrideIPNURL", request.getOverrideIPNURL());
        }
        return params;
    }

    private Map<String, String> convertWriteOffDebt(WriteOffDebtRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "WriteOffDebt");
        if (request.isSetCreditInstrumentId()) {
            params.put("CreditInstrumentId", request.getCreditInstrumentId());
        }
        if (request.isSetAdjustmentAmount()) {
            Amount adjustmentAmount = request.getAdjustmentAmount();
            if (adjustmentAmount.isSetCurrencyCode()) {
                params.put("AdjustmentAmount.CurrencyCode", adjustmentAmount.getCurrencyCode().value());
            }
            if (adjustmentAmount.isSetValue()) {
                params.put("AdjustmentAmount.Value", adjustmentAmount.getValue());
            }
        }
        if (request.isSetCallerReference()) {
            params.put("CallerReference", request.getCallerReference());
        }
        if (request.isSetCallerDescription()) {
            params.put("CallerDescription", request.getCallerDescription());
        }
        return params;
    }

    private Map<String, String> convertGetRecipientVerificationStatus(GetRecipientVerificationStatusRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "GetRecipientVerificationStatus");
        if (request.isSetRecipientTokenId()) {
            params.put("RecipientTokenId", request.getRecipientTokenId());
        }
        return params;
    }

    private Map<String, String> convertVerifySignature(VerifySignatureRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "VerifySignature");
        if (request.isSetUrlEndPoint()) {
            params.put("UrlEndPoint", request.getUrlEndPoint());
        }
        if (request.isSetHttpParameters()) {
            params.put("HttpParameters", request.getHttpParameters());
        }
        return params;
    }

    static {
        ERROR_PATTERN_ONE = Pattern.compile(".*\\<RequestId>(.*)\\</RequestId>.*\\<Error>\\<Code>(.*)\\</Code>\\<Message>(.*)\\</Message>\\</Error>.*(\\<Error>)?.*", 40);
        ERROR_PATTERN_TWO = Pattern.compile(".*\\<Error>\\<Code>(.*)\\</Code>\\<Message>(.*)\\</Message>\\</Error>.*(\\<Error>)?.*\\<RequestID>(.*)\\</RequestID>.*", 40);
        DEFAULT_ENCODING = "UTF-8";
        try {
            jaxbContext = JAXBContext.newInstance((String)"com.amazonaws.fps.model", (ClassLoader)AmazonFPS.class.getClassLoader());
        }
        catch (JAXBException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        unmarshaller = new ThreadLocal<Unmarshaller>(){

            @Override
            protected synchronized Unmarshaller initialValue() {
                try {
                    return jaxbContext.createUnmarshaller();
                }
                catch (JAXBException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
        };
    }
}

