/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPutAttributesRequest
extends AmazonWebServiceRequest {
    private String domainName;
    private List<ReplaceableItem> items;

    public BatchPutAttributesRequest() {
    }

    public BatchPutAttributesRequest(String domainName, List<ReplaceableItem> items) {
        this.domainName = domainName;
        this.items = items;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public BatchPutAttributesRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public List<ReplaceableItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<ReplaceableItem>();
        }
        return this.items;
    }

    public void setItems(Collection<ReplaceableItem> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        ArrayList<ReplaceableItem> itemsCopy = new ArrayList<ReplaceableItem>(items.size());
        itemsCopy.addAll(items);
        this.items = itemsCopy;
    }

    public BatchPutAttributesRequest withItems(ReplaceableItem ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<ReplaceableItem>(items.length));
        }
        for (ReplaceableItem value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public BatchPutAttributesRequest withItems(Collection<ReplaceableItem> items) {
        if (items == null) {
            this.items = null;
        } else {
            ArrayList<ReplaceableItem> itemsCopy = new ArrayList<ReplaceableItem>(items.size());
            itemsCopy.addAll(items);
            this.items = itemsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName != null) {
            sb.append("DomainName: " + this.domainName + ", ");
        }
        if (this.items != null) {
            sb.append("Items: " + this.items + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : ((Object)this.getItems()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutAttributesRequest)) {
            return false;
        }
        BatchPutAttributesRequest other = (BatchPutAttributesRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || ((Object)other.getItems()).equals(this.getItems());
    }
}

