/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlList
implements Serializable {
    private static final long serialVersionUID = 8095040648034788376L;
    private HashSet<Grant> grants = new HashSet();
    private Owner owner = null;

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void grantPermission(Grantee grantee, Permission permission) {
        this.grants.add(new Grant(grantee, permission));
    }

    public void grantAllPermissions(Grant ... grantsVarArg) {
        for (Grant gap : grantsVarArg) {
            this.grantPermission(gap.getGrantee(), gap.getPermission());
        }
    }

    public void revokeAllPermissions(Grantee grantee) {
        ArrayList<Grant> grantsToRemove = new ArrayList<Grant>();
        for (Grant gap : this.grants) {
            if (!gap.getGrantee().equals(grantee)) continue;
            grantsToRemove.add(gap);
        }
        this.grants.removeAll(grantsToRemove);
    }

    public Set<Grant> getGrants() {
        return this.grants;
    }

    public String toString() {
        return "AccessControlList [owner=" + this.owner + ", grants=" + this.getGrants() + "]";
    }
}

