/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.ListTablesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTablesRequestMarshaller
implements Marshaller<Request<ListTablesRequest>, ListTablesRequest> {
    @Override
    public Request<ListTablesRequest> marshall(ListTablesRequest listTablesRequest) {
        if (listTablesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTablesRequest> request = new DefaultRequest<ListTablesRequest>(listTablesRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.ListTables";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listTablesRequest.getExclusiveStartTableName() != null) {
                jsonWriter.key("ExclusiveStartTableName").value(listTablesRequest.getExclusiveStartTableName());
            }
            if (listTablesRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(listTablesRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

