% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roundHalfUp.R
\name{roundHalfUp}
\alias{roundHalfUp}
\title{Round a number with 'rounding up' strategy 
for rounding off a 5}
\usage{
roundHalfUp(x, digits = 0)
}
\arguments{
\item{x}{Numeric vector to round.}

\item{digits}{Integer with number of digits to consider, 0 by default.}
}
\value{
Rounded numeric vector.
}
\description{
This function rounds a number for a specified number of digits.
It rounds off to the highest number for a 5.
The default R \code{\link{round}} function rounds to the
'even digit' in case of rounding off a 5 
(see 'Details' section in \code{? round}).
This function instead rounds up to the nearest number for a 5. 
It mimics a similar rounding strategy used in SAS.
See examples for the difference between \code{\link{round}} and
'roundHalfUp' below.
}
\examples{
# numbers are rounded to the closest even number in case of .5 
# with the round 'base' function
round(0.45, 1)
# 'roundHalfUp' always round to the next highest number in case of .5
roundHalfUp(0.45, 1)
# rounding is the same for uneven number:
round(0.55, 1)
roundHalfUp(0.55)
# other examples
round(1.456e-2, digits = 3)
round(1.456e-2, digits = 2)
round(1.456e-2, digits = 1)
}
\author{
stackoverflow question 6461209
}
