% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadDataADaMSDTM.R
\name{getLabelVars}
\alias{getLabelVars}
\title{Get label of the variables in SAS dataset(s)}
\usage{
getLabelVars(data, labelVars = NULL)
}
\arguments{
\item{data}{Data.frame with SAS dataset(s) or list of those.}

\item{labelVars}{(optional) Named character vector with additional labels.}
}
\value{
Named vector with variable labels.
}
\description{
Get label of the variables in SAS dataset(s)
}
\examples{
data(dataADaMCDISCP01)
labelVars <- attr(dataADaMCDISCP01, "labelVars")

# extract label for all variables from specified datasets:
getLabelVars(data = dataADaMCDISCP01[c("ADLBC", "ADVS")], labelVars = labelVars)

# extracted from specified labelVars, e.g. to specify custom label for specific variable(s)
labelVarsCustom <- getLabelVars(
  data = dataADaMCDISCP01, 
  labelVars = c(USUBJID = "Subject identifier for my study")
)
labelVarsCustom["USUBJID"]
}
\author{
Laure Cougnaud
}
