% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render_clinDataReviewReport.R
\name{render_clinDataReviewReport}
\alias{render_clinDataReviewReport}
\title{Render a clinical data report.}
\usage{
render_clinDataReviewReport(
  configFiles = NULL,
  configDir = file.path(inputDir, "config"),
  logFile = NULL,
  indexPath = file.path(inputDir, "index.Rmd"),
  inputDir = ".",
  outputDir = "./report",
  intermediateDir = "./interim",
  extraDirs = file.path(inputDir, c("figures", "tables")),
  quiet = FALSE
)
}
\arguments{
\item{configFiles}{(optional) Character vector with specific config files
to be converted from Rmarkdown to Markdown. If
\itemize{
\item{not specified (by default): }{all config files
specified in the general 'config.yml' will be run (Rmd -> md)}
\item{specified (\strong{expert use only}): }{only the specified files will be run (Rmd -> md).
Other config files mentioned in the general 
'config.yml' file won't be rerun, so the associated 'md' file
should be already available in the \code{intermediateDir} folder.
}
}}

\item{configDir}{String with directory with config files,
by default a 'config' folder in \code{inputDir}.\cr
It should contain a general 'config.yml' file and dedicated
'config-[X].yml' for each chapter.
The order of each chapter is specified in the 'config' slot in the general 
general 'config.yml'.}

\item{logFile}{(optional) String with path to a log file,
where output (also error/messages/warnings) should be stored.
If specified, the entire output is re-directed to this file.}

\item{indexPath}{String with path to the index file,
by default 'index.Rmd' in \code{inputDir}.}

\item{inputDir}{String with input directory,
working directory by default.}

\item{outputDir}{String with output directory,
('report' by default).}

\item{intermediateDir}{String with intermediate directory ('interim'
by default), where
markdown files and rds file specifying Js libraries (with \code{knit_meta}) for
each sub report are stored.}

\item{extraDirs}{Character vector with extra directories required by
the report, directory with external images  .
By default, the directories: 'figures', 'tables' and mentioned in the 
'patientProfilePath' parameter of the
general config file are included.
All these folders should be available in \code{inputDir}.}

\item{quiet}{Logical, if TRUE (FALSE by default)
progress messages during report execution are not displayed
in the console (see \code{\link[rmarkdown]{render}}).}
}
\value{
String with path to the front page of the 
clinical data report.
}
\description{
Render a clinical data report.
}
\section{Framework}{
 
This function is based on the \link[bookdown]{render_book}
function, enabling specification of chapter-specific input parameters,
specified in YAML configuration files.
This consists of:
\enumerate{
\item{importing the general config file ('config'.yml) to identify
each report of interest ('config' tag)}
\item{for each report of interest:
\itemize{
\item{loading the report specific parameters from the associated 'config' file
(see the \code{\link{getParamsFromConfig}} function)}
\item{if the template should be extracted from a specified package
(\code{templatePackage} tag), this template is copied to the
current directory.
Please note that if a file with same name is available in
the working directory, this file will be overwritten.
}
\item{executing the report ('template' tag) with the associated
parameters in a \strong{new R session for reproducibility}, 
to obtain the associated Markdown file}
}}
\item{combining all Markdown files to a html document
(see the \code{\link{convertMdToHtml}} function)
}
}
If the execution of a specific report fails with error, 
a warning message is triggered. A report containing
only the specified title is created, to ensure
output consistency (especially html file numbering)
in case the report succeeds.
}

\section{Available template report}{

see \strong{\code{? `clinDataReview-templates`}} for list of 
clinical data template report available in the package.
}

\seealso{
Other clinical data reporting: 
\code{\link{checkReportTitles}()},
\code{\link{convertMdToHtml}()},
\code{\link{forceParams}()},
\code{\link{getMdHeader}()},
\code{\link{getParamsFromConfig}()},
\code{\link{gitbook_clinDataReview_report}()},
\code{\link{html_clinDataReview_report}()},
\code{\link{knitPrintClinDataReview}()}
}
\author{
Laure Cougnaud
}
\concept{clinical data reporting}
