% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climaemet_main.R
\name{climatogram_normal}
\alias{climatogram_normal}
\title{Walter & Lieth climatic diagram from normal climatology values}
\usage{
climatogram_normal(station, apikey, labels = c("en", "es", ""))
}
\arguments{
\item{station}{Character string as station identifier code (see \code{\link{aemet_stations}}).}

\item{apikey}{Character string as personal API key (see \url{https://opendata.aemet.es/centrodedescargas/obtencionAPIKey}).}

\item{labels}{Character string as month labels for the X axis: "en" (english), "es" (spanish) or blank (numeric labels: 1-12).}
}
\value{
a plot.
}
\description{
Plot of a Walter & Lieth climatic diagram from normal climatology data for a station. This climatogram are great for showing a summary of climate conditions for a place over a time period ((1981-2010).
}
\note{
The code is based on code from the CRAN package "climatol" by Jose A. Guijarro \href{mailto:jguijarrop@aemet.es}{jguijarrop@aemet.es}.
}
\examples{
\dontrun{
climatogram_normal(station, apikey, labels = "en")
}

}
\references{
Walter, H. & Lieth, H (1960): Klimadiagramm Weltatlas. G. Fischer, Jena.
}
\seealso{
See more details in the "diagwl" function \code{\link[climatol]{diagwl}}.
}
