% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{chk_deprecated}
\alias{chk_deprecated}
\alias{chk_dirs}
\alias{chk_files}
\alias{chk_length}
\alias{chk_count}
\alias{chk_proportion}
\alias{chk_in}
\alias{chk_has}
\alias{chk_is}
\alias{vld_is}
\alias{chk_no_missing}
\alias{vld_no_missing}
\alias{chk_on}
\alias{chk_off}
\alias{is_chk_on}
\title{Deprecated functions}
\usage{
chk_dirs(x)

chk_files(x)

chk_length(x, length = 1L, x_name = NULL)

chk_count(x, x_name = NULL)

chk_proportion(x, x_name = NULL)

chk_in(x, values, x_name = NULL)

chk_has(x, values, x_name = NULL)

chk_is(x, class, x_name = NULL)

vld_is(x, class)

chk_no_missing(x, x_name = NULL)

vld_no_missing(x)

chk_on()

chk_off()

is_chk_on()
}
\arguments{
\item{x}{The object to check.}

\item{length}{A count of the length.}

\item{x_name}{A string of the name of object x or NULL.}
}
\description{
Deprecated \code{chk_()} functions.
}
\section{Functions}{
\itemize{
\item \code{chk_dirs}: Check Directories Exist

\lifecycle{soft-deprecated}

Checks if directories exist using:

\code{all(dir.exists(x))}

Replace by \code{\link[=chk_dir]{chk_dir()}}.

\item \code{chk_files}: Check Files Exist

\lifecycle{soft-deprecated}

Checks if files exist using:

\code{all(file.exists(x) && !dir.exists(x))}

Replace by \code{\link[=chk_file]{chk_file()}}.

\item \code{chk_length}: Check Length

\lifecycle{deprecated}

Checks if is length length using:

\code{length(x) == length}

\code{length} should be a count.

Replace by \verb{[chk_range](length(x))}.

\item \code{chk_count}: Check Count

\lifecycle{deprecated}

Checks if non-missing non-negative integer scalar or double equivalent using:

\code{is.numeric(x) && length(x) == 1L && !anyNA(x) && x >= 0 && vld_true(all.equal(x, as.integer(x)))}

Replace by \code{\link[=chk_whole_number]{chk_whole_number()}} and \code{\link[=chk_gte]{chk_gte()}}.

\item \code{chk_proportion}: Check Proportion

\lifecycle{deprecated}

Checks if non-missing numeric scalar between 0 and 1 using:

\code{is.numeric(x) && length(x) == 1L && !anyNA(x) && x >= 0 && x <= 1}

Replace by \code{\link[=chk_number]{chk_number()}} and \code{\link[=chk_range]{chk_range()}}.

\item \code{chk_in}: Check In

\lifecycle{soft-deprecated}

Checks if all values in values using \code{chk_subset()}.

Replace by \code{\link[=chk_subset]{chk_subset()}}.

\item \code{chk_has}: Check Has

\lifecycle{soft-deprecated}

Checks if includes all values using \code{chk_superset()}.

Replace by \code{\link[=chk_superset]{chk_superset()}}.

\item \code{chk_is}: Check Is

\lifecycle{soft-deprecated}

Checks if inherits from class using \code{vld_is()}.

Replace by \code{\link[=chk_s3_class]{chk_s3_class()}} or \code{\link[=chk_s4_class]{chk_s4_class()}}.

\item \code{vld_is}: Validate Is

\lifecycle{soft-deprecated}

Validates inherits from class using

\code{inherits(x, class)}

Class should be a string.

\item \code{chk_no_missing}: Check No Missing Values

Checks if no missing values using
\code{vld_no_missing()}.

\item \code{vld_no_missing}: Validate No Missing Values

Validates no missing values using

\code{!anyNA(x)}.

\item \code{chk_on}: Turns checking on

\lifecycle{soft-deprecated}

\item \code{chk_off}: Turns checking off

\lifecycle{soft-deprecated}

\item \code{is_chk_on}: Tests checking on

\lifecycle{soft-deprecated}
}}

\examples{

# chk_is
chk_is(1, "numeric")
try(chk_is(1, "character"))

# vld_is
vld_is(numeric(0), "numeric")
vld_is(1, "numeric")
vld_is(NA_real_, "numeric")
vld_is(1, "character")
vld_is(NULL, "numeric")

# chk_no_missing
chk_no_missing(1)
try(chk_no_missing(c(1, NA)))

# vld_no_missing
vld_no_missing(character(0))
vld_no_missing(1)
vld_no_missing(1:10)
vld_no_missing(NA)
vld_no_missing(c(1, NA))
}
\seealso{
\code{\link[=anyNA]{anyNA()}}
}
\keyword{internal}
