% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-ext.R
\name{chk_ext}
\alias{chk_ext}
\alias{vld_ext}
\title{Check File Extension}
\usage{
chk_ext(x, ext, x_name = NULL)

vld_ext(x, ext)
}
\arguments{
\item{x}{The object to check.}

\item{ext}{A character vector of the permitted file extensions (without the .).}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks extension using

\code{vld_string(x) && vld_subset(tools::file_ext(x), ext)}

The user may want to use \code{\link[=toupper]{toupper()}} or \code{\link[=tolower]{tolower()}}
to ensure the case matches.
}
\section{Functions}{
\itemize{
\item \code{vld_ext}: Validate File Extension
}}

\examples{

# chk_ext
try(chk_ext("file1.pdf", "png"))

# vld_ext
vld_ext("oeu.pdf", "pdf")
vld_ext(toupper("oeu.pdf"), "PDF")
}
\seealso{
Other chk_files: \code{\link{chk_dir}},
  \code{\link{chk_file}}
}
\concept{chk_files}
