% Generated by roxygen2 (4.0.2): do not edit by hand
\name{checkInt}
\alias{assertInt}
\alias{checkInt}
\alias{testInt}
\title{Check if an argument is a single integerish value}
\usage{
checkInt(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps))

assertInt(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), .var.name)

testInt(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than.}

\item{tol}{[\code{double(1)}]\cr
Numerical tolerance used to check whether a double or complex can be converted.
Default is \code{sqrt(.Machine$double.eps)}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertInt} throws an error message,
 \code{testInt} returns \code{FALSE} and \code{checkInt} returns
 a string with the error message.
}
\description{
Check if an argument is a single integerish value
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testInt(1)
testInt(-1, lower = 0)
}
\seealso{
Other scalars: \code{\link{assertCount}},
  \code{\link{checkCount}}, \code{\link{testCount}};
  \code{\link{assertFlag}}, \code{\link{checkFlag}},
  \code{\link{testFlag}}; \code{\link{assertNumber}},
  \code{\link{checkNumber}}, \code{\link{testNumber}};
  \code{\link{assertPercentage}},
  \code{\link{checkPercentage}},
  \code{\link{testPercentage}};
  \code{\link{assertScalarNA}},
  \code{\link{checkScalarNA}}, \code{\link{testScalarNA}};
  \code{\link{assertScalar}}, \code{\link{checkScalar}},
  \code{\link{testScalar}}; \code{\link{assertString}},
  \code{\link{checkString}}, \code{\link{testString}}
}

