% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{pairsByTime}
\alias{pairsByTime}
\title{Distance between pairs of tracks at every timepoint}
\usage{
pairsByTime(X, searchRadius = Inf, times = timePoints(X), quietly = FALSE)
}
\arguments{
\item{X}{a tracks object}

\item{searchRadius}{if specified, return only pairs that are within this distance of each other. 
Defaults to \code{Inf}, so if left unspecified, all pairs are returned.}

\item{times}{(optional) a vector of timePoints to check pairs at; by default this is just everything.}

\item{quietly}{(default FALSE) if TRUE, suppress warnings when there are no tracks with
overlapping timepoints and an empty dataframe is returned.}
}
\value{
a dataframe with the following columns:
\describe{
  \item{cell1}{the id of the track to which the first coordinate belongs}
  \item{cell2}{the id of the track to which the second coordinate belongs}
	 \item{t}{the time point at which their distance is assessed}
	 \item{dist}{the distance between the coordinates at this time}
}
}
\description{
For every timepoint in the dataset, compute pairwise distances between coordinates.
}
\examples{
## compute find timepoints where two t cells are within 1 micron of each other.
pairsByTime( TCells, searchRadius = 1 )

## indeed, the following two cells nearly touch:
plot( TCells[ c("24","9258") ] )
}
