% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-data.R
\name{get_data}
\alias{get_data}
\title{Get data from Statistics Netherlands (CBS)}
\usage{
get_data(id, ..., recode = TRUE, use_column_title = recode,
  dir = tempdir(), base_url = getOption("cbsodataR.base_url",
  BASE_URL))
}
\arguments{
\item{id}{Identifier of table, can be found in \code{\link{get_table_list}}}

\item{...}{optional filter statemenets}

\item{recode}{Should the categories of the table be recoded with their title
(TRUE) or with their key (FALSE)?}

\item{use_column_title}{Should column names be coded with title (TRUE)
or key (FALSE)}

\item{dir}{Directory where the table should be downloaded. Defaults to temporary
directory}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocol.}
}
\value{
\code{data.frame} with the requested data. Note that a csv copy of the data is stored in \code{dir}.
}
\description{
Retrieves data from a table of Statistics Netherlands. A list of tables
can be retrieved with \code{\link{get_table_list}}. 
Optionaly the data can be filtered on category values. 
The filter is specified with \code{<column_name> = <values>} in which \code{<values>} is a character vector.
Rows with values that are not part of the character vector are not returned. Note that the values
have to be raw (un-recoded) values.
}
\note{
All data are downloaded using \code{\link{download_table}}
}
\examples{
\dontrun{

# get data for main (000000) Consumer Price Index (7196ENG) for March 2000, 
 get_data(id="7196ENG", Periods="2000MM03", CPI="000000")
}
}
