% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_search.R
\name{wass_grid_search}
\alias{wass_grid_search}
\title{Wasserstein grid search}
\usage{
wass_grid_search(
  data,
  grid = NULL,
  grid.length = 8,
  estimand = c("ATT", "ATC", "cATE", "ATE"),
  K = 10,
  R = 10,
  n.boot = 100,
  eval.method = c("bootstrap", "cross.validation"),
  method = c("Wasserstein", "Constrained Wasserstein", "SCM"),
  sample_weight = NULL,
  wass.method = "sinkhorn_geom",
  wass.iter = 1000,
  epsilon = 1,
  lambda = 100,
  unbiased = TRUE,
  add.joint = TRUE,
  add.margins = FALSE,
  add.divergence = FALSE,
  joint.mapping = FALSE,
  verbose = FALSE,
  neg.weights = FALSE,
  cgd = FALSE,
  ...
)
}
\arguments{
\item{data}{Object of class \code{matrix}, \code{data.frame}, or \code{DataSim}.}

\item{grid}{Either NULL or a vector of values to check.}

\item{grid.length}{Number of grid values.}

\item{estimand}{One of "ATT", "ATC", "ATE"}

\item{K}{Number of folds if using k-fold}

\item{R}{Number of times to repeat k-folds}

\item{n.boot}{Number of bootstrapped samples}

\item{eval.method}{One of "bootstrap" or "cross.validation"}

\item{method}{One of "Wasserstein","Constrained Wasserstein", "SCM".}

\item{sample_weight}{NULL or object of class \link[=sampleWeights-class]{sampleWeights}}

\item{wass.method}{OT algorithm for evaluating balance. Default "sinkhorn_geom" but otherwise should be a method supported by the approxOT package.}

\item{wass.iter}{Number of iterations to run algorithm}

\item{epsilon}{Used to calculated the penalty factor for the \code{wass.method}.
\code{lambda = epsilon*median(cost)}.}

\item{lambda}{For the Sinkhorn wass.method, the lambda value directly,}

\item{unbiased}{Should an de-biased Sinkhorn distance be used for \code{wass.method}?}

\item{add.joint}{Add the joint cost matrix?}

\item{add.margins}{Add the marginal constraints}

\item{add.divergence}{add the divergence}

\item{joint.mapping}{Should the algorithm do joint mapping,
barycentric projection and OT.}

\item{verbose}{Should the function print progress?}

\item{neg.weights}{Allow the weights to be negative?}

\item{cgd}{Use conditional gradient descent?}

\item{...}{extra arguments passed to \link{prep_data} or \link{extract_x}}
}
\value{
object of class \link[=causalWeights-class]{causalWeights}
}
\description{
Wasserstein grid search
}
\keyword{internal}
