% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cat-class.R
\name{getters}
\alias{getters}
\alias{getModel,Cat-method}
\alias{getModel}
\alias{getGuessing,Cat-method}
\alias{getGuessing}
\alias{getDiscrimination,Cat-method}
\alias{getDiscrimination}
\alias{getDifficulty,Cat-method}
\alias{getDifficulty}
\alias{getAnswers,Cat-method}
\alias{getAnswers}
\alias{getIds,Cat-method}
\alias{getIds}
\alias{getPriorName,Cat-method}
\alias{getPriorName}
\alias{getPriorParams,Cat-method}
\alias{getPriorParams}
\alias{getLowerBound,Cat-method}
\alias{getLowerBound}
\alias{getUpperBound,Cat-method}
\alias{getUpperBound}
\alias{getEstimation,Cat-method}
\alias{getEstimation}
\alias{getEstimationDefault,Cat-method}
\alias{getEstimationDefault}
\alias{getSelection,Cat-method}
\alias{getSelection}
\alias{getZ,Cat-method}
\alias{getZ}
\alias{getLengthThreshold,Cat-method}
\alias{getLengthThreshold}
\alias{getSeThreshold,Cat-method}
\alias{getSeThreshold}
\alias{getInfoThreshold,Cat-method}
\alias{getInfoThreshold}
\alias{getGainThreshold,Cat-method}
\alias{getGainThreshold}
\alias{getLengthOverride,Cat-method}
\alias{getLengthOverride}
\alias{getGainOverride,Cat-method}
\alias{getGainOverride}
\title{Methods for Accessing \code{Cat} Object Slots}
\usage{
\S4method{getModel}{Cat}(catObj)

\S4method{getGuessing}{Cat}(catObj)

\S4method{getDiscrimination}{Cat}(catObj)

\S4method{getDifficulty}{Cat}(catObj)

\S4method{getAnswers}{Cat}(catObj)

\S4method{getIds}{Cat}(catObj)

\S4method{getPriorName}{Cat}(catObj)

\S4method{getPriorParams}{Cat}(catObj)

\S4method{getLowerBound}{Cat}(catObj)

\S4method{getUpperBound}{Cat}(catObj)

\S4method{getEstimation}{Cat}(catObj)

\S4method{getEstimationDefault}{Cat}(catObj)

\S4method{getSelection}{Cat}(catObj)

\S4method{getZ}{Cat}(catObj)

\S4method{getLengthThreshold}{Cat}(catObj)

\S4method{getSeThreshold}{Cat}(catObj)

\S4method{getInfoThreshold}{Cat}(catObj)

\S4method{getGainThreshold}{Cat}(catObj)

\S4method{getLengthOverride}{Cat}(catObj)

\S4method{getGainOverride}{Cat}(catObj)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}
}
\value{
These functions return the respective slot from Cat object.
}
\description{
Getter methods to access slots of a \code{Cat} object.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Getting estimation slot before and after change
getEstimation(ltm_cat)
setEstimation(ltm_cat) <- "MAP"
getEstimation(ltm_cat)

## Getting discrimination slot before and after change
getDiscrimination(ltm_cat)
setDiscrimination(ltm_cat) <- rep(1, 40)
getDiscrimination(ltm_cat)


}
\references{
Montgomery, Jacob M., and Erin L. Rossiter. "So many questions, so little time: 
Integrating adaptive inventories into public opinion research." Journal of Survey Statistics and Methodology (2019).
}
\seealso{
\code{\link{Cat-class}}, \code{\link{setters}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery, 
Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
