% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{checkStopRules}
\alias{checkStopRules}
\title{Check if Stop and/or Override Rules are Met}
\usage{
checkStopRules(catObj)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}
}
\value{
The function \code{checkStopRules} returns a boolean.  \code{TRUE} indicates all specified stopping rules are met
  and no specified overrides are met.  No further items should be administered.  \code{FALSE} indicates at least one specified
   stopping rule is not met, or if any specified override threshold is met.  Additional items should be administered.
}
\description{
Evaluates the specified stopping and/or override rules to check if respondent should be asked further questions.
}
\details{
The stopping rule thresholds are stored in the following \code{Cat} object slots:
\code{lengthThreshold}, \code{seThreshold}, \code{infoThreshold}, and \code{gainThreshold}. The override
 thresholds are stored in the following \code{Cat} object slots: \code{lengthOverride}, \code{gainOverride}.  
 A value of \code{NA} indicates the rule will not be used in evaluating if further questions should be administered.
 A user can specify any combination of stopping rules and/or overrides.  
 
  \strong{Stopping Rules:}

  \code{lengthThreshold}: Number of question's answered \eqn{\geq a}
 
  \code{seThreshold}: \eqn{SE(\hat{\theta}) < a}
 
  \code{infoThreshold}: \eqn{FI < a} \eqn{\forall} remaining items

  \code{gainThreshold}: \eqn{SE(\hat{\theta}) - \sqrt{EPV} | < a} \eqn{\forall} remaining items

  \strong{Overrides:}

  \code{lengthOverride}: Number of question's answered \eqn{< a}

  \code{gainOverride}: \eqn{|SE(\hat{\theta}) - \sqrt{EPV} | \geq a} \eqn{\forall} remaining items
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1,0,0,0,1,1, rep(NA, 30))

## Stop administering items if standard error of ability
## estimate is low enough
setSeThreshold(ltm_cat) <- .5
checkStopRules(ltm_cat)

## Now stop if standard error is low enough, but only if respondent has
## answered 11 questions 
setLengthOverride(ltm_cat) <- 11
checkStopRules(ltm_cat)

## When respondent has answered 11 questions and standard error
## of ability estimate is below .5, stop administering items
setAnswers(ltm_cat) <- c(1,0,1,0,1,0,0,0,1,1,0, rep(NA, 29))
checkStopRules(ltm_cat)


}
\references{
Babcock, Ben, and David J. Weiss. 2009. ``Termination Criteria in Computerized Adaptive Tests: Variable-Length CATs are not Biased." Proceedings of the 2009 GMAC Conference on Computerized Adaptive Testing. Vol. 14.
}
\seealso{
\code{\link{Cat-class}}, \code{\link{estimateSE}}, \code{\link{expectedPV}}, \code{\link{fisherInf}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
