% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_models.R
\name{exp_decay_rate}
\alias{exp_decay_rate}
\title{Calculate an Exponential Decay Rate From Two Appropriate Pairs of Values}
\usage{
exp_decay_rate(t_1, t_2, y_1, y_2)
}
\arguments{
\item{t_1}{Earlier point in time, coupled to \code{y_1}}

\item{t_2}{Later point in time, coupled to \code{y_2}}

\item{y_1}{Earlier value, coupled to \code{t_1}}

\item{y_2}{Later value, coupled to \code{t_2}}
}
\value{
The exponential decay rate \code{r}, relating to the time unit of
\code{t_1} and \code{t_2}
}
\description{
Assuming an exponential decay process y = exp(-r * t), this function
calculates r if the following informaion is given:\cr y_1 = exp(-r \* t_1),
y_2 = exp(-r \* t_2)\cr Hereby, t_1 is the earlier, t_2 the later point in
time. This implies the following conditions: t_2 > t_1, y_2 <= y_1\cr If
these conditions are not given, the function will terminate with an error.
}
\examples{
  # Up to an age of t_1 = 30, a forest stand of interest has a survival
  # probability of 0.95. Up to an age of t_2 = 80, it has a survival
  # probability of 0.83. If we assume an exponential decay process for the
  # 50-year period, what is the exponential decay rate r?
  r <- exp_decay_rate(30, 80, 0.95, 0.83)
  print(r)

  # Check it
  0.95 * exp(-r * (80 - 30)) # 0.83

}
