% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_binary_score}
\alias{get_binary_score}
\title{Compute a binary score.}
\usage{
get_binary_score(x, answer)
}
\arguments{
\item{x}{A character or numeric vector representing a response to a questionnaire item.}

\item{answer}{A character or numeric vector representing the correct answer(s) to the questionnaire item. The answer argument does not have to match x
in case for a correct answer to be computed.}
}
\value{
Returns 1 (if correct), 0 (if incorrect) or NA (if not valid).
}
\description{
This function computes a binary score (0 = incorrect answer, 1 = correct answer) for a response to a questionnaire item based on the value(s) set as
answer(s) to the item.
}
\details{
This function is called by \code{\link[=get_fill_in_the_blanks_score]{get_fill_in_the_blanks_score()}}.
}
\examples{
get_binary_score(
  x = c(1:4, NA, ""),
  answer = 3
)

# [1]  0  0  1  0 NA  0

get_binary_score(
  x = c("20 minutes", "30 minutes", "60 minutes or 1 hour", "120 minutes or 2 hours"),
  answer = "60 minutes or 1 hour"
)

# [1] 0 0 1 0

get_binary_score(
  x = c(1:5, "Heart", "hello, world", NA),
  answer = c(3, "heart")
)

# [1]  0  0  1  0  0  1  0 NA

}
