% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairscan_kin.R
\name{pairscan_kin}
\alias{pairscan_kin}
\title{Run the pairscan with a kinship correction}
\usage{
pairscan_kin(
  data_obj,
  geno_obj,
  scan_what,
  marker_pairs,
  kin_obj,
  verbose = FALSE,
  run_parallel = FALSE,
  n_cores = 2
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{geno_obj}{a genotype object}

\item{scan_what}{A character string uniquely identifying whether eigentraits
or raw traits should be scanned. Options are "eigentraits", "raw_traits"}

\item{marker_pairs}{A two-column matrix containing the marker pairs
to be tested.}

\item{kin_obj}{a kinship object}

\item{verbose}{A logical value indicating whether to 
print progress to the screen}

\item{run_parallel}{A logical value indicating 
whether parallel processing should be used}

\item{n_cores}{The number of cores to be used if run_parallel is TRUE}
}
\value{
This function returns a list with three elements. 
The elements contain the marker pair effect sizes, the marker
pair standard errors, and the covariance matrix for each test.
The output is then further processed by \code{\link{pairscan}}.
}
\description{
This function is called by \code{\link{pairscan}}
when a kinship correction is requested. It adjusts 
each variable according to the kinship matrix using
\code{\link{kin_adjust}} and then fits linear
pairwise models to the adjusted data.
}
\keyword{internal}
