% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layout_mat.R
\name{get_layout_mat}
\alias{get_layout_mat}
\title{Get the best layout matrix for a given number of panes per page.}
\usage{
get_layout_mat(num_panes, type = c("landscape", "upright"))
}
\arguments{
\item{num_panes}{The number of images to plot per page.}

\item{type}{A character vector specifying whether the layout matrix 
should have more columns than rows ("landscape"), or more rows than 
columns ("upright"), if the resulting matrix is not square.}
}
\value{
A layout matrix with positions for each element in num_panes
and zeros filling the rest of the rectangle where nothing will be plotted.
}
\description{
This function is for automatically deciding how to lay out multiple
images per page. It takes as an argument the number of images the user
wants on a single page and returns the most square matrix possible.
}
\keyword{internal}
