% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geno_with_covar.R
\name{get_geno_with_covar}
\alias{get_geno_with_covar}
\title{Return the genotype matrix with covariates 
added.}
\usage{
get_geno_with_covar(
  data_obj,
  geno_obj = NULL,
  g_covar = TRUE,
  p_covar = TRUE,
  for_pairscan = TRUE
)
}
\arguments{
\item{data_obj}{The cape object. See \code{\link{Cape}}.}

\item{geno_obj}{A genotype object.}

\item{g_covar}{A logical value indicating whether to append
genotype-derived covariates to the final matrix. Defaults to TRUE.}

\item{p_covar}{A logical value indicating whether to append
phenotype-derived covariates to the final matrix. Defaults to TRUE.}

\item{for_pairscan}{If TRUE, the function returns the genotype matrix 
already designated for the pairscan. Otherwise it returns the full
genotype matrix as specified by data_obj$geno_names.}
}
\value{
Returns a genotype matrix with covariates appended.
}
\description{
For pairwise testing, cape appends the covariates
to the genotype matrix. This function performs
that task.
}
\keyword{internal}
