% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_unused_markers.R
\name{remove_unused_markers}
\alias{remove_unused_markers}
\title{Take out markers not used in cape}
\usage{
remove_unused_markers(data_obj, geno_obj, verbose = FALSE)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{geno_obj}{a genotype object}

\item{verbose}{A logical value indicating whether to print progress 
to the screen. Default is FALSE}
}
\value{
an updated \code{\link{Cape}} object (data_obj)
}
\description{
This function removes any markers that are not
used in cape. This includes markers on the sex 
chromosomes, mitochondrial markers, and any 
invariant markers.
}
\examples{
\dontrun{
data_obj <- remove_unused_markers(data_obj, geno_obj)
}

}
