% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairscan_null_kin.R
\name{pairscan_null_kin}
\alias{pairscan_null_kin}
\title{Generates a null distribution for the pairscan}
\usage{
pairscan_null_kin(
  data_obj,
  geno_obj = NULL,
  kin_obj = NULL,
  scan_what = c("eigentraits", "raw_traits"),
  pairscan_null_size = NULL,
  max_pair_cor = NULL,
  min_per_geno = NULL,
  model_family = "gaussian",
  marker_selection_method = c("top_effects", "uniform", "effects_dist", "by_gene"),
  run_parallel = FALSE,
  n_cores = 4,
  verbose = FALSE
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{geno_obj}{a genotype object}

\item{kin_obj}{a kinship object}

\item{scan_what}{A character string uniquely identifying whether eigentraits
or raw traits should be scanned. Options are "eigentraits", "raw_traits"}

\item{pairscan_null_size}{The total size of the null distribution.
This is DIFFERENT than the number of permutations to run. Each permutation
generates n choose 2 elements for the pairscan. So for example, a permutation
that tests 100 pairs of markers will generate a null distribution of size 4950.
This process is repeated until the total null size is reached. If the null size
is set to 5000, two permutations of 100 markers would be done to get to a null
distribution size of 5000.}

\item{max_pair_cor}{A numeric value between 0 and 1 indicating the maximum
Pearson correlation that two markers are allowed. If the correlation
between a pair of markers exceeds this threshold, the pair is not tested.
If this value is set to NULL, min_per_genotype must have a numeric value.}

\item{min_per_geno}{The minimum number of individuals allowable per
genotype. If for a given marker pair, one of the genotypes is
underrepresented, the marker pair is not tested. If this value is NULL,
max_pair_cor must have a numeric value.}

\item{model_family}{Indicates the model family of the phenotypes. This can be 
either "gaussian" or "binomial".}

\item{marker_selection_method}{options are "top_effects", "uniform", "effects_dist", "by_gene"}

\item{run_parallel}{Whether to run the analysis on multiple CPUs.}

\item{n_cores}{The number of CPUs to use if run_parallel is TRUE.}

\item{verbose}{Whether to print progress to the screen. Defaults to FALSE.}
}
\value{
This function returns a list with two elements, one containing
the results of the permutations, and the other containing the markers
that were tested in the individual permutations.
}
\description{
This function generates a null distribution
for the pairscan. For each permutation,
it runs a single scan and selects markers
in the same manner as for the true test.
}
\keyword{internal}
