% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker2covar.R
\name{marker2covar}
\alias{marker2covar}
\title{Creates a covariate from a genetic marker}
\usage{
marker2covar(
  data_obj,
  geno_obj,
  singlescan_obj = NULL,
  covar_thresh = NULL,
  markers = NULL
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{geno_obj}{a genotype object}

\item{singlescan_obj}{It is possible to automatically identify
markers to use as covariates based on their large main effects.
If this is desired, a singlescan object is required.}

\item{covar_thresh}{If designating markers as covariates based
on their main effect size is desired, the covar_thresh indicates
the main effect size above which a marker is designated as a 
covariate.}

\item{markers}{Marker covariates can also be designated manually.
markers takes in a vector of marker names or numbers and assigns
the designated markers as covariates.}
}
\value{
This function returns the data object with additional 
information specifying which markers are to be used as covariates.
this information can be retrieved with \code{\link{get_covar}}.
}
\description{
Occasionally, researchers may want to condition 
marker effects on another genetic marker. For example,
the HLA locus in humans has very strong effects on 
immune phenotypes, and can swamp smaller effects from
other markers. It can be helpful to condition on markers
in the HLA region to find genetic modifiers of these 
markers.
}
\examples{
\dontrun{
#convert markers with effect sizes greater than 6 to covariates.
#this requires a singlescan_obj
data_obj <- marker2covar(data_obj, geno_obj, singlescan_obj, covar_thresh = 6)

#convert the first marker to a covariate
#this does not require a singlescan_obj
marker_name <- dimnames(geno_obj)[[3]][1]
data_obj <- marker2covar(data_obj, geno_obj, markers = marker_name)
}
}
\seealso{
\code{\link{get_covar}}
}
