% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caRamel.R
\name{caRamel}
\alias{caRamel}
\title{MAIN FUNCTION: multi-objective optimizer}
\usage{
caRamel(nobj, nvar, minmax, bounds, func, popsize, archsize, maxrun, prec,
  repart_gene = c(5, 5, 5, 5), gpp = NULL, blocks = NULL, pop = NULL,
  funcinit = NULL, objnames = NULL, listsave = NULL, write_gen = 0,
  carallel = TRUE, numcores = NULL, graph = TRUE)
}
\arguments{
\item{nobj}{: (integer, length = 1) the number of objectives to optimize (nobj >= 2)}

\item{nvar}{: (integer, length = 1) the number of variables}

\item{minmax}{: (logical, length = nobj) the objective is either a minimization (FALSE value) or a maximization (TRUE value)}

\item{bounds}{: (matrix, nrow = nvar, ncol = 2) lower and upper bounds for the variables}

\item{func}{: the name of the objective function to optimize. Input argument is the number of parameter set (integer) in the x matrix. The function has to return a vector of at least 'nobj' values (Objectives 1 to nobj are used for optimization, values after nobj are recorded for information.).}

\item{popsize}{: (integer, length = 1) the population size for the genetic algorithm}

\item{archsize}{: (integer, length = 1) the size of the Pareto front}

\item{maxrun}{: (integer, length = 1) the max. number of simulations allowed}

\item{prec}{: (double, length = nobj) the desired accuracy for the optimization of the objectives}

\item{repart_gene}{: (integer, length = 4) optional, number of new parameter sets for each rule and per generation}

\item{gpp}{: (integer, length = 1) optional, calling frequency for the rule "Fireworks"}

\item{blocks}{(optional): groups for parameters}

\item{pop}{: (matrix, nrow = nset, ncol = nvar or nvar+nobj ) optional, initial population (used to restart an optimization)}

\item{funcinit}{(optional): the name of the initialization function applied on each node of cluster when parallel computation. The arguments are cl and numcores.}

\item{objnames}{(optional): the name of the objectives}

\item{listsave}{(optional): names of the listing files. Default: None (no output). If exists, fields to be defined: "pmt" (file of parameters on the Pareto Front), "obj" (file of corresponding objective values), "evol" (evolution of maximum objectives by generation). Optional field: "totalpop" (total population and corresponding objectives, useful to restart a computation)}

\item{write_gen}{: (integer, length = 1) optional, if = 1, save files 'pmt' and 'obj' at each generation (= 0 by default)}

\item{carallel}{: (logical, length = 1) optional, do parallel computations (TRUE by default)}

\item{numcores}{: (integer, length = 1) optional, the number of cores for the parallel computations (all cores by default).}

\item{graph}{: (logical, length = 1) optional, plot graphical output at each generation (TRUE by default).}
}
\value{
List of five elements:
\describe{
\item{success}{return value (logical, length = 1) : TRUE if successfull}
\item{parameters}{Pareto front (matrix, nrow = archsize, ncol = nvar)}
\item{objectives}{objectives of the Pareto front (matrix, nrow = archsize, ncol = nobj+nadditional)}
\item{save_crit}{evolution of the optimal objectives}
\item{total_pop}{total population (matrix, nrow = popsize+archsize, ncol = nvar+nobj+nadditional)}
}
}
\description{
Multi-objective optimizer. It requires to define a multi-objective function (func) to calibrate the model and bounds on the parameters to optimize.
}
\details{
The optimizer was originally written for Scilab by Nicolas Le Moine.
The algorithm is a hybrid of the MEAS algorithm (Efstratiadis and Koutsoyiannis (2005) <doi:10.13140/RG.2.2.32963.81446>) by using the directional search method based on the simplexes of the objective space 
    and the epsilon-NGSA-II algorithm with the method of classification of the parameter vectors archiving management by epsilon-dominance (Reed and Devireddy <doi:10.1142/9789812567796_0004>).
Documentation : "Principe de l'optimiseur CaRaMEL et illustration au travers d'exemples de parametres dans le cadre de la modelisation hydrologique conceptuelle"
                Frederic Hendrickx (EDF) and Nicolas Le Moine (UPMC)
                Report EDF H-P73-2014-09038-FR
}
\examples{
# Definition of the test function
viennet <- function(i) {
  val1 <- 0.5*(x[i,1]*x[i,1]+x[i,2]*x[i,2])+sin(x[i,1]*x[i,1]+x[i,2]*x[i,2])
  val2 <- 15+(x[i,1]-x[i,2]+1)*(x[i,1]-x[i,2]+1)/27+(3*x[i,1]-2*x[i,2]+4)*(3*x[i,1]-2*x[i,2]+4)/8
  val3 <- 1/(x[i,1]*x[i,1]+x[i,2]*x[i,2]+1) -1.1*exp(-(x[i,1]*x[i,1]+x[i,2]*x[i,2]))
  return(c(val1,val2,val3))
}
# Number of objectives
nobj <- 3
# Number of variables
nvar <- 2
# All the objectives are to be minimized
minmax <- c(FALSE, FALSE, FALSE)
# Define the bound constraints
bounds <- matrix(data = 1, nrow = nvar, ncol = 2)
bounds[, 1] <- -3 * bounds[, 1]
bounds[, 2] <- 3 * bounds[, 2]

# Caramel optimization
results <-
  caRamel(nobj = nobj,
          nvar = nvar,
          minmax =  minmax,
          bounds = bounds,
          func = viennet,
          popsize = 100,
          archsize = 100,
          maxrun = 500,
          prec = matrix(1.e-3, nrow = 1, ncol = nobj),
          carallel = FALSE)

}
\author{
Fabrice Zaoui - Celine Monteil
}
