% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_infer.R
\name{inference_helper}
\alias{inference_helper}
\alias{MeanResample}
\alias{SdResample}
\alias{BiasResample}
\alias{StandardCIResample}
\alias{PercentilCIResample}
\alias{BasicCIResample}
\alias{TStatCIResample}
\alias{BcCIResample}
\alias{BcaCIResample}
\title{Internal: Helper for infer()}
\usage{
MeanResample(.first_resample)

SdResample(.first_resample, .resample_method, .n)

BiasResample(.first_resample, .resample_method, .n)

StandardCIResample(
  .first_resample,
  .bias_corrected,
  .dist = c("z", "t"),
  .df = c("type1", "type2"),
  .resample_method,
  .n,
  .probs
)

PercentilCIResample(.first_resample, .probs)

BasicCIResample(.first_resample, .bias_corrected, .probs)

TStatCIResample(
  .first_resample,
  .second_resample,
  .bias_corrected,
  .resample_method,
  .resample_method2,
  .n,
  .probs
)

BcCIResample(.first_resample, .probs)

BcaCIResample(.object, .first_resample, .probs)
}
\arguments{
\item{.first_resample}{A list containing the \code{.R} resamples based on the original
data obtained by resamplecSEMResults().}

\item{.resample_method}{Character string. The resampling method to use. One of:
"\emph{none}", "\emph{bootstrap}" or "\emph{jackknife}". Defaults to "\emph{none}".}

\item{.n}{Integer. The number of observations of the original data.}

\item{.bias_corrected}{Logical. Should the standard and the tStat
confidence interval be bias-corrected using the bootstrapped bias estimate?
If \code{TRUE} the confidence interval for some estimated parameter \code{theta}
is centered at \verb{2*theta - theta*_hat},
where \verb{theta*_hat} is the average over all \code{.R} bootstrap estimates of \code{theta}.
Defaults to \code{TRUE}}

\item{.dist}{Character string. The distribution to use for the critical value.
One of \emph{"t"} for Student's t-distribution or \emph{"z"} for the standard normal distribution.
Defaults to \emph{"z"}.}

\item{.df}{Character string. The method for obtaining the degrees of freedom.
Choices are "\emph{type1}" and "\emph{type2}". Defaults to "\emph{type1}" .}

\item{.probs}{A vector of probabilities.}

\item{.second_resample}{A list containing \code{.R2} resamples for each of the \code{.R}
resamples of the first run.}

\item{.resample_method2}{Character string. The resampling method to use when resampling
from a resample. One of: "\emph{none}", "\emph{bootstrap}" or "\emph{jackknife}". For
"\emph{bootstrap}" the number of draws is provided via \code{.R2}. Currently,
resampling from each resample is only required for the studentized confidence
intervall ("\emph{CI_t_interval}") computed by the \code{\link[=infer]{infer()}} function. Defaults to "\emph{none}".}

\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}
}
\description{
Collection of various functions that compute an inferential quantity.
}
\details{
Implementation and termionology of the confidence intervals is based on
\insertCite{Hesterberg2015;textual}{cSEM} and
\insertCite{Davison1997;textual}{cSEM}.
}
\references{
\insertAllCited{}
}
\keyword{internal}
