% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cristin_wrangler.R
\name{CristinWrangler}
\alias{CristinWrangler}
\title{Wrangle Cristin metadata into Zotero-type format}
\usage{
CristinWrangler(
  data,
  use.identifiers = TRUE,
  crossref.search = FALSE,
  autosearch = TRUE,
  override = FALSE,
  silent = FALSE,
  polite = TRUE,
  log = list()
)
}
\arguments{
\item{data}{Tibble containing metadata from Cristin}

\item{use.identifiers}{Use if ISBN/DOI identifiers if enabled, Default: TRUE}

\item{crossref.search}{Query Crossref database based on title, authors, and
date if enabled, Default: FALSE}

\item{autosearch}{Results could be automatically evaluated (based on some
logic) or you could inspect them manually if set to FALSE, Default: TRUE}

\item{override}{Put your faith in the algorithms and the identifiers (i.e.,
DOI/ISBN) and override what is reported in Cristin, Default: FALSE}

\item{silent}{Running silent, running deep, Default: FALSE}

\item{polite}{Please store you email in `.Renviron` to query Crossref,
Default: TRUE}

\item{log}{A list for storing log elements, Default: list()}
}
\value{
A Zotero-type matrix (tibble)
}
\description{
The little engine that could, at least try, to wrangle metadata
  from Cristin into a Zotero-type matrix. References can be augmented, or
  replaced with metadata gathered through ISBN or DOI identifiers, and
  through Crossref queries if all other fails. Or, hope the best and place
  your misguided faith in the ability of researchers to correctly register
  their own publications.
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Simple `Cristin` search by id with import set as FALSE
  example <- Cristin(id = "840998", zotero.import = FALSE)
  # Check if results i supported using `CristinSupported`
  example.supported <- CristinSupported(example$results)
  # Use `ZoteroIndex` to print `CristinWrangler`
  ZoteroIndex(CristinWrangler(example.supported$data)$results) |>
    dplyr::select(name) |>
    print(width = 80)
}
}
\seealso{
\code{\link[tidyr]{unnest}}, {\link[tidyr]{nest}}
 \code{\link[dplyr]{filter}}, \code{\link[dplyr]{across}},
 \code{\link[dplyr]{reexports}}, \code{\link[dplyr]{bind}},
 \code{\link[dplyr]{mutate}}, \code{\link[dplyr]{distinct}}
 \code{\link[httr]{RETRY}}
 \code{\link[tibble]{tibble}}
}
