% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doi_crossref.R
\name{DoiCrossref}
\alias{DoiCrossref}
\title{Wrangle CrossRef metadata into Zotero-type format}
\usage{
DoiCrossref(data, meta = list())
}
\arguments{
\item{data}{XML data from CrossRef containing metadata}

\item{meta}{A list collecting all metadata used to create , Default: list()}
}
\value{
A Zotero-type matrix (tibble)
}
\description{
Query CrossRef by DOI and fetch metadata
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # `DoiCrossref` is called from `ZoteroDoi` (if item found)
  example <- ZoteroDoi("10.1126/sciadv.abd1705")

  # Print index using `ZoteroIndex`
  ZoteroIndex(example) |>
    dplyr::select(name) |>
    print(width = 80)

  # Display catalog
  example$libraryCatalog
}
}
